package com.supwisdom.institute.backend.system.api.vo.response;

import lombok.Getter;
import lombok.Setter;

import java.util.List;
import java.util.Map;

import org.springframework.data.domain.Page;

import com.supwisdom.institute.backend.common.framework.vo.request.IApiQueryRequest;
import com.supwisdom.institute.backend.common.framework.vo.response.data.IApiQueryResponseData;
import com.supwisdom.institute.backend.system.domain.entity.Resource;

/**
 * @author loie
 */
public class ResourceQueryResponseData implements IApiQueryResponseData<Resource> {

  /**
   * 
   */
  private static final long serialVersionUID = 241098548786558434L;

  private ResourceQueryResponseData(boolean loadAll, int pageIndex, int pageSize, Map<String, Object> mapBean, Map<String, String> orderBy) {
    this.loadAll = loadAll;
    this.pageIndex = pageIndex;
    this.pageSize = pageSize;
    this.mapBean = mapBean;
    this.orderBy = orderBy;
  }

  public static ResourceQueryResponseData of(IApiQueryRequest queryRequest) {
    ResourceQueryResponseData configQueryResponse = new ResourceQueryResponseData(
        queryRequest.isLoadAll(), 
        queryRequest.getPageIndex(), 
        queryRequest.getPageSize(), 
        queryRequest.getMapBean(), 
        queryRequest.getOrderBy()
    );
    
    return configQueryResponse;
  }
  
  public ResourceQueryResponseData build(Page<Resource> page) {
    this.currentItemCount = page.getNumberOfElements();
    this.pageCount = page.getTotalPages();
    this.recordCount = page.getTotalElements();
    this.items = page.getContent();

    return this;
  }

  @Getter
  private boolean loadAll;
  @Getter
  private int pageIndex;
  @Getter
  private int pageSize;
  @Getter
  private Map<String, Object> mapBean;
  @Getter
  private Map<String, String> orderBy;
  
  @Getter
  @Setter
  private int pageCount;
  @Getter
  @Setter
  private long recordCount;
  
  @Getter
  @Setter
  private int currentItemCount;
  
  @Getter
  @Setter
  private List<Resource> items;
  
}
