package com.supwisdom.institute.backend.system.domain.repo;

import java.util.Map;

import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Repository;

import com.supwisdom.institute.backend.common.framework.repo.BaseJpaRepository;
import com.supwisdom.institute.backend.common.util.MapBeanUtils;
import com.supwisdom.institute.backend.system.domain.entity.Group;

@Repository
public interface GroupRepository extends BaseJpaRepository<Group> {

  @Override
  public default Page<Group> selectPageList(boolean loadAll, int pageIndex, int pageSize, Map<String, Object> mapBean, Map<String, String> orderBy) {
    if (loadAll) {
      pageIndex = 0;
      pageSize = Integer.MAX_VALUE;
    }
    
    Group probe = new Group();
    if (mapBean != null) {
      probe.setDeleted(MapBeanUtils.getBoolean(mapBean, "deleted"));
      probe.setCode(MapBeanUtils.getString(mapBean, "code"));
      probe.setName(MapBeanUtils.getString(mapBean, "name"));
      probe.setMemo(MapBeanUtils.getString(mapBean, "memo"));
      probe.setStatus(MapBeanUtils.getString(mapBean, "status"));
    }
    
    ExampleMatcher matcher = ExampleMatcher.matching()
        .withMatcher("deleted", ExampleMatcher.GenericPropertyMatchers.exact())
        .withMatcher("code", ExampleMatcher.GenericPropertyMatchers.contains())
        .withMatcher("name", ExampleMatcher.GenericPropertyMatchers.contains())
        .withMatcher("memo", ExampleMatcher.GenericPropertyMatchers.contains())
        .withMatcher("status", ExampleMatcher.GenericPropertyMatchers.exact());
    
    PageRequest pageRequest = PageRequest.of(pageIndex, pageSize);
    Example<Group> example = Example.of(probe, matcher);
    
    Page<Group> page = this.findAll(example, pageRequest);
    
    return page;
  }
  
}
