package com.supwisdom.institute.backend.admin.bff.security.web.access.intercept;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class InMemeryFilterInvocationSecurityMetadataSource implements FilterInvocationSecurityMetadataSource {
  
  private Map<RequestMatcher, Collection<ConfigAttribute>> requestMap = null;
  
  private void loadRequestMap() {
    if (requestMap == null) {
      requestMap = new LinkedHashMap<RequestMatcher, Collection<ConfigAttribute>>();
      
      AntPathRequestMatcher requestMatcher0 = new AntPathRequestMatcher("/api/**");
      Collection<ConfigAttribute> attributes0 = new ArrayList<ConfigAttribute>();  // FIXME: 返回当前请求的url 对应的 角色代码
      attributes0.add(new SecurityConfig("user"));
      requestMap.put(requestMatcher0, attributes0);

      
      AntPathRequestMatcher requestMatcher = new AntPathRequestMatcher("/web/**");
      Collection<ConfigAttribute> attributes = new ArrayList<ConfigAttribute>();  // FIXME: 返回当前请求的url 对应的 角色代码
      attributes.add(new SecurityConfig("user"));
      requestMap.put(requestMatcher, attributes);
    }
  }

  /**
   * 获取当前请求关联的所有角色code {@link SecurityConfig} 
   * 用于和用户拥有的角色code 进行比对
   */
  @Override
  public Collection<ConfigAttribute> getAttributes(Object object) throws IllegalArgumentException {
    
    if (requestMap == null) {
      loadRequestMap();
    }

    HttpServletRequest request = ((FilterInvocation) object).getHttpRequest();
    
    RequestMatcher requestMatcher;
    for(Iterator<RequestMatcher> iter = requestMap.keySet().iterator(); iter.hasNext(); ) {
      requestMatcher = iter.next();
      
      if(requestMatcher.matches(request)) {
        return requestMap.get(requestMatcher);
      }
    }
    
    return null;
  }

  @Override
  public Collection<ConfigAttribute> getAllConfigAttributes() {

    return null;
  }

  @Override
  public boolean supports(Class<?> clazz) {

    return true;
  }

}
