package com.supwisdom.institute.backend.biz.domain.repo;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.data.domain.Sort.Order;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

import com.supwisdom.institute.backend.biz.domain.entity.Biz;
import com.supwisdom.institute.backend.common.framework.repo.BaseJpaRepository;
import com.supwisdom.institute.backend.common.util.DateUtil;
import com.supwisdom.institute.backend.common.util.MapBeanUtils;

@Repository
public interface BizRepository extends BaseJpaRepository<Biz> {
  
  default Specification<Biz> convertSpecification(Map<String, Object> mapBean) {

    Specification<Biz> spec = new Specification<Biz>() {

      /**
       * 
       */
      private static final long serialVersionUID = -1820403213133310124L;

      @Override
      public Predicate toPredicate(Root<Biz> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
        List<Predicate> predicates = new ArrayList<>();
        
        if (mapBean != null) {
          if (!StringUtils.isEmpty(MapBeanUtils.getString(mapBean, "name"))) {
            predicates.add(criteriaBuilder.like(root.get("name"), MapBeanUtils.getString(mapBean, "name")));
          }

          if (!StringUtils.isEmpty(MapBeanUtils.getBoolean(mapBean, "bool"))) {
            predicates.add(criteriaBuilder.equal(root.get("bool"), MapBeanUtils.getBoolean(mapBean, "bool")));
          }
          
          if (!StringUtils.isEmpty(MapBeanUtils.getString(mapBean, "dateBegin"))) {
            String grantTimeBegin = MapBeanUtils.getString(mapBean, "dateBegin");
            Date d = DateUtil.parseDate(grantTimeBegin+" 00:00:00", "yyyy-MM-dd HH:mm:ss");
            
            if (d != null) {
              predicates.add(criteriaBuilder.greaterThanOrEqualTo(root.get("date"), d));
            }
          }

          if (!StringUtils.isEmpty(MapBeanUtils.getString(mapBean, "dateEnd"))) {
            String grantTimeEnd = MapBeanUtils.getString(mapBean, "dateEnd");
            Date d = DateUtil.parseDate(grantTimeEnd+" 23:59:59", "yyyy-MM-dd HH:mm:ss");
            
            if (d != null) {
              predicates.add(criteriaBuilder.lessThanOrEqualTo(root.get("date"), d));
            }
          }
        }
        
        return criteriaBuilder.and(predicates.toArray(new Predicate[predicates.size()]));
      }
      
    };
    
    return spec;
  }
  
  @Override
  public default Page<Biz> selectPageList(boolean loadAll, int pageIndex, int pageSize, Map<String, Object> mapBean, Map<String, String> orderBy) {
    
    Specification<Biz> spec = this.convertSpecification(mapBean);

    if (loadAll) {
      pageIndex = 0;
      pageSize = Integer.MAX_VALUE;
    }
    
    Sort sort = new Sort(Sort.Direction.DESC, "date");  // Sort.unsorted

    if (orderBy != null) {
      List<Order> orders = new ArrayList<>();
      
      orderBy.forEach((k, v) -> {
        if ("asc".equalsIgnoreCase(v)) {
          Order order = Order.asc(k);
          orders.add(order);
        } else if ("desc".equalsIgnoreCase(v)) {
          Order order = Order.desc(k);
          orders.add(order);
        } else {
          Order order = Order.by(k);
          orders.add(order);
        }
      });
      
      sort = Sort.by(orders);
    }

    PageRequest pageRequest = PageRequest.of(pageIndex, pageSize, sort);
    
    return this.findAll(spec, pageRequest);
  }

}
