package com.supwisdom.institute.backend.admin.bff.apis.remote.base.v1.authn;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.alibaba.fastjson.JSONObject;
import com.supwisdom.institute.backend.admin.bff.apis.remote.base.configuration.BaseFeignClientConfiguration;

@FeignClient(
    configuration = {BaseFeignClientConfiguration.class},
    name = "base-admin-account-remote-feign-client",
    url = "${sw-backend-base-api.uri}/v1/authn",
    fallbackFactory = AuthnAccountRemoteFallbackFactory.class
)
public interface AuthnAccountRemoteFeignClient {
  
  @RequestMapping(method = RequestMethod.GET, path = "/{username}/account")
  JSONObject account(
      @PathVariable(name = "username") String username);

  @RequestMapping(method = RequestMethod.GET, path = "/{username}/roles")
  JSONObject roles(
      @PathVariable(name = "username") String username);

  @RequestMapping(method = RequestMethod.GET, path = "/{username}/applications")
  JSONObject applications(
      @PathVariable(name = "username") String username,
      @RequestParam(name = "applicationId", required = false) String applicationId);

  @RequestMapping(method = RequestMethod.GET, path = "/{username}/menus")
  JSONObject menus(
      @PathVariable(name = "username") String username,
      @RequestParam(name = "applicationId", required = false) String applicationId);

  @RequestMapping(method = RequestMethod.GET, path = "/{username}/operations")
  JSONObject operations(
      @PathVariable(name = "username") String username,
      @RequestParam(name = "applicationId", required = false) String applicationId);


  @RequestMapping(method = RequestMethod.GET, path = "/{username}/resources")
  JSONObject resources(
      @PathVariable(name = "username") String username,
      @RequestParam(name = "applicationId", required = false) String applicationId);

}
