package com.supwisdom.institute.backend.admin.bff.api.v1.controller.open;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.MimeTypeUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import com.supwisdom.institute.backend.admin.bff.api.v1.model.base.PermissionRoleSet;
import com.supwisdom.institute.backend.admin.bff.api.v1.model.open.Menu;
import com.supwisdom.institute.backend.admin.bff.api.v1.service.base.AuthnService;
import com.supwisdom.institute.backend.admin.bff.api.v1.vo.open.response.data.MenusResponseData;
import com.supwisdom.institute.backend.common.framework.vo.response.DefaultApiResponse;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

@Api(value = "BFFOpen", tags = { "open" }, description = "公开接口")
@RestController
@RequestMapping(value = "/api/v1/open")
public class OpenController {
  
  @Autowired
  private AuthnService authnService;
  
  @ApiOperation(
      tags = { "open" },
      value = "获取菜单", notes = "获取菜单", nickname = "openMenus"
  )
  @RequestMapping(method = RequestMethod.GET, path = "/menus", produces = MimeTypeUtils.APPLICATION_JSON_VALUE)
  public DefaultApiResponse<MenusResponseData> menus() {
    
    List<Menu> menus = new ArrayList<>();

    List<PermissionRoleSet> permissionRoleSets = authnService.getPermissionRoleSets("1"); // XXX: applicationId
    if (permissionRoleSets != null) {
      for (PermissionRoleSet permissionRoleSet : permissionRoleSets) {
        Menu menu = new Menu();
        BeanUtils.copyProperties(permissionRoleSet, menu);
        menus.add(menu);
      }
    }
    
    MenusResponseData data = MenusResponseData.of(menus);
    return new DefaultApiResponse<MenusResponseData>(data);
  }
  

}
