package com.supwisdom.institute.backend.admin.aggr.apis.remote.biz;

import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSONObject;
import com.supwisdom.institute.backend.admin.aggr.apis.model.biz.Biz;
import com.supwisdom.institute.backend.admin.aggr.apis.remote.exception.FallbackError;

import feign.hystrix.FallbackFactory;

@Component
public class BizRemoteFallbackFactory implements FallbackFactory<BizRemoteFeignClient> {

  @Override
  public BizRemoteFeignClient create(Throwable cause) {
    return new BizRemoteFeignClient() {

      @Override
      public JSONObject query(boolean loadAll, int pageIndex, int pageSize) {
        if (cause != null) {
          cause.printStackTrace();
        }
        return FallbackError.defaultErrorJson(cause);
      }

      @Override
      public JSONObject load(String id) {
        if (cause != null) {
          cause.printStackTrace();
        }
        return FallbackError.defaultErrorJson(cause);
      }

      @Override
      public JSONObject create(Biz biz) {
        if (cause != null) {
          cause.printStackTrace();
        }
        return FallbackError.defaultErrorJson(cause);
      }

      @Override
      public JSONObject update(String id, Biz biz) {
        if (cause != null) {
          cause.printStackTrace();
        }
        return FallbackError.defaultErrorJson(cause);
      }

      @Override
      public JSONObject delete(String id) {
        if (cause != null) {
          cause.printStackTrace();
        }
        return FallbackError.defaultErrorJson(cause);
      }
      
    };
  }

}
