package com.supwisdom.institute.backend.admin.aggr.apis.remote.biz;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.alibaba.fastjson.JSONObject;
import com.supwisdom.institute.backend.admin.aggr.apis.model.biz.Biz;

@FeignClient(
    name = "biz-biz-remote-feign-client",
    url = "${sw-backend-biz-api.uri}/v1/admin/biz",
    fallbackFactory = BizRemoteFallbackFactory.class
)
public interface BizRemoteFeignClient {
  
  @RequestMapping(method = RequestMethod.GET)
  JSONObject query(
      @RequestParam(name = "loadAll") boolean loadAll,
      @RequestParam(name = "pageIndex") int pageIndex,
      @RequestParam(name = "pageSize") int pageSize
      
  );
  
  @RequestMapping(method = RequestMethod.GET, path = "/{id}")
  JSONObject load(
      @PathVariable(name = "id") String id
  );

  @RequestMapping(method = RequestMethod.POST)
  JSONObject create(
      @RequestBody Biz biz
  );

  @RequestMapping(method = RequestMethod.PUT, path = "/{id}")
  JSONObject update(
      @PathVariable(name = "id") String id,
      @RequestBody Biz biz
  );
  
  @RequestMapping(method = RequestMethod.DELETE, path = "/{id}")
  JSONObject delete(
      @PathVariable(name = "id") String id
  );

}
