package com.supwisdom.institute.backend.admin.aggr.apis.service.biz;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSONObject;
import com.supwisdom.institute.backend.admin.aggr.apis.remote.biz.BizRemoteFeignClient;
import com.supwisdom.institute.backend.admin.aggr.apis.vo.biz.response.data.BizQueryResponseData;

@Service
public class BizService {
  
  @Autowired
  private BizRemoteFeignClient bizRemote;
  
  public BizQueryResponseData query(boolean loadAll, int pageIndex, int pageSize) {
    
    JSONObject jsonObject = bizRemote.query(loadAll, pageIndex, pageSize);
    if (jsonObject == null) {
      return null;
    }
    
    if (jsonObject.getIntValue("code") == 0) {
      JSONObject data = jsonObject.getJSONObject("data");
      
      return data.toJavaObject(BizQueryResponseData.class);
    }
    
    return null;
  }

}
