package com.supwisdom.institute.backend.admin.aggr.configuration;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;

import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ResourceUtils;

import feign.Client;
import lombok.extern.slf4j.Slf4j;

@Slf4j
@Configuration
public class FeignClientConfiguration {

  @Bean
  public Client feignClient(
      @Value("${cas-server-sa-api.client-auth.enabled:false}") boolean enabled,
      @Value("${cas-server-sa-api.client-auth.key-password:}") String keyPassword,
      @Value("${cas-server-sa-api.client-auth.key-store:}") String keyStore,
      @Value("${cas-server-sa-api.client-auth.key-store-password:}") String keyStorePassword,
      @Value("${cas-server-sa-api.client-auth.trust-store:}") String trustStore,
      @Value("${cas-server-sa-api.client-auth.trust-store-password:}") String trustStorePassword) {
    
    if (!enabled) {
      return new Client.Default(null, null);
    }
    
    if (keyStore == null || keyStore.isEmpty()) {
      return new Client.Default(null, null);
    } else {
      try {
        SSLContextBuilder sslContextBuilder = SSLContexts.custom();
        if (trustStore == null || trustStore.isEmpty()) {
        } else {
          sslContextBuilder
//            .loadTrustMaterial(TrustAllStrategy.INSTANCE)
            .loadTrustMaterial(
                ResourceUtils.getFile(trustStore),
                trustStorePassword.toCharArray()
            );
        }
        
        sslContextBuilder
          .loadKeyMaterial(
              ResourceUtils.getFile(keyStore),
              keyStorePassword.toCharArray(),
              keyPassword.toCharArray());
        
        SSLContext sslContext = sslContextBuilder.build();
        
        SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();

        Client trustSSLSockets = new Client.Default(sslSocketFactory, new NoopHostnameVerifier());
        log.info("feignClient load with ssl.");
        return trustSSLSockets;
      } catch (Exception e) {
        e.printStackTrace();
      }
    }
    
    return new Client.Default(null, null);
  }

}
