package com.supwisdom.institute.backend.gateway.agent.poa.service;

import java.util.List;

import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.supwisdom.institute.backend.gateway.agent.poa.model.Role;
import com.supwisdom.institute.backend.gateway.agent.poa.remote.web.client.AgentPoaRemoteClient;

@Slf4j
@Service
public class AuthzService {
  
  @Autowired
  private AgentPoaRemoteClient agentPoaRemoteClient;
  
  public List<Role> loadAccountApplicationRoles(String username) {

    JSONObject jsonObject = agentPoaRemoteClient.loadAccountApplicationRoles(username);
    if (jsonObject == null) {
      return null;
    }
    
    JSONObject data = jsonObject.getJSONObject("data");
    
    JSONArray roleArray = data.getJSONArray("roles");
    
    List<Role> roles = roleArray.toJavaList(Role.class);
    log.debug("{}", roles);
    
    return roles;
  }
}
