package com.supwisdom.institute.backend.gateway.agent.poa.service;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSONObject;
import com.supwisdom.institute.backend.gateway.agent.poa.model.UserInfoModel;
import com.supwisdom.institute.backend.gateway.agent.poa.remote.web.client.AgentPoaRemoteClient;

import lombok.extern.slf4j.Slf4j;

@Slf4j
@Service
public class UserService {

  @Autowired
  private AgentPoaRemoteClient agentPoaRemoteClient;
  
  public UserInfoModel loadUserInfoByAccountName(String accountName) {
    
    JSONObject jsonObject = agentPoaRemoteClient.loadUserInfoByAccountName(accountName);
    if (jsonObject == null) {
      return null;
    }
    
    JSONObject data = jsonObject.getJSONObject("data");
    
    UserInfoModel userInfoModel = data.toJavaObject(UserInfoModel.class);
    log.debug("userInfoModel: [{}]", userInfoModel);
    
    return userInfoModel;
  }

}
