package com.supwisdom.institute.backend.gateway.configuration;

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import com.supwisdom.institute.backend.gateway.security.core.userdetails.InMemeryUserDetailsService;
import com.supwisdom.institute.backend.gateway.security.core.userdetails.MyUserDetailsService;
import com.supwisdom.institute.backend.gateway.security.core.userdetails.PoaUserDetailsService;

import lombok.extern.slf4j.Slf4j;

@Slf4j
@Configuration
public class UserDetailsServiceConfig {

  @Bean
  @ConditionalOnProperty(name = "sw-backend-gateway.security.core.userdetails.service.impl", havingValue = "memery", matchIfMissing = true)
  public InMemeryUserDetailsService inMemeryUserDetailsService() throws Exception {
    InMemeryUserDetailsService inMemeryUserDetailsService = new InMemeryUserDetailsService();
    log.debug("UserDetailsServiceConfig inMemeryUserDetailsService is {}", inMemeryUserDetailsService);

    return inMemeryUserDetailsService;
  }
  
  @Bean
  @ConditionalOnProperty(name = "sw-backend-gateway.security.core.userdetails.service.impl", havingValue = "poa", matchIfMissing = false)
  public PoaUserDetailsService poaUserDetailsService() throws Exception {
    PoaUserDetailsService poaUserDetailsService = new PoaUserDetailsService();
    log.debug("UserDetailsServiceConfig poaUserDetailsService is {}", poaUserDetailsService);

    return poaUserDetailsService;
  }

  @Bean
  @ConditionalOnProperty(name = "sw-backend-gateway.security.core.userdetails.service.impl", havingValue = "base", matchIfMissing = false)
  public MyUserDetailsService myUserDetailsService() throws Exception {
    MyUserDetailsService myUserDetailsService = new MyUserDetailsService();
    log.debug("UserDetailsServiceConfig myUserDetailsService is {}", myUserDetailsService);

    return myUserDetailsService;
  }

}
