package com.supwisdom.institute.backend.system.api.vo.response;

import lombok.Getter;
import lombok.Setter;

import java.util.List;
import java.util.Map;

import org.springframework.data.domain.Page;

import com.supwisdom.institute.backend.common.framework.vo.response.data.IApiQueryResponseData;
import com.supwisdom.institute.backend.system.api.vo.request.ConfigQueryRequest;
import com.supwisdom.institute.backend.system.domain.entity.Config;

/**
 * @author loie
 */
public class ConfigQueryResponseData implements IApiQueryResponseData<Config> {
  
  /**
   * 
   */
  private static final long serialVersionUID = 3188467441502226095L;
  
//  private ConfigQueryResponseData() {
//  }
  
  public ConfigQueryResponseData(boolean loadAll, int pageIndex, int pageSize, Map<String, Object> mapBean, Map<String, String> orderBy) {
    this.loadAll = loadAll;
    this.pageIndex = pageIndex;
    this.pageSize = pageSize;
    this.mapBean = mapBean;
    this.orderBy = orderBy;
  }

  public static ConfigQueryResponseData of(ConfigQueryRequest configQueryRequest) {
    ConfigQueryResponseData configQueryResponse = new ConfigQueryResponseData(
        configQueryRequest.isLoadAll(), 
        configQueryRequest.getPageIndex(), 
        configQueryRequest.getPageSize(), 
        configQueryRequest.getMapBean(), 
        configQueryRequest.getOrderBy()
    );
    
    return configQueryResponse;
  }
  
  public ConfigQueryResponseData build(Page<Config> page) {
    this.currentItemCount = page.getNumberOfElements();
    this.pageCount = page.getTotalPages();
    this.recordCount = page.getTotalElements();
    this.items = page.getContent();

    return this;
  }

  @Getter
  private boolean loadAll;
  @Getter
  private int pageIndex;
  @Getter
  private int pageSize;
  @Getter
  private Map<String, Object> mapBean;
  @Getter
  private Map<String, String> orderBy;
  
  @Getter
  @Setter
  private int pageCount;
  @Getter
  @Setter
  private long recordCount;
  
  @Getter
  @Setter
  private int currentItemCount;
  
  @Getter
  @Setter
  private List<Config> items;
  
}
