

CREATE TABLE `TB_BASE_ACCOUNT` (
  `ID` VARCHAR(100) NOT NULL COMMENT '',
  `COMPANY_ID` VARCHAR(100) COMMENT 'CompanyID',
  `DELETED` INT(1) COMMENT '是否删除',
  `ADD_ACCOUNT` VARCHAR(100) COMMENT '创建人',
  `ADD_TIME` DATETIME COMMENT '创建时间',
  `EDIT_ACCOUNT` VARCHAR(100) COMMENT '修改人',
  `EDIT_TIME` DATETIME COMMENT '修改时间',
  `DELETE_ACCOUNT` VARCHAR(100) COMMENT '删除人',
  `DELETE_TIME` DATETIME COMMENT '删除时间',

  `USERNAME` VARCHAR(200) NOT NULL COMMENT '账号',
  `PASSWORD` VARCHAR(200) NOT NULL COMMENT '密码',

  `ENABLED` INT(11) NOT NULL COMMENT '是否可用，1 可用，0 不可用，默认：1',
  `ACCOUNT_NON_EXPIRED` INT(11) NOT NULL COMMENT '账号未过期，1 未过期，0 过期，默认：1',
  `ACCOUNT_NON_LOCKED` INT(11) NOT NULL COMMENT '账号未锁定，1 未锁定，0 锁定，默认：1',
  `CREDENTIALS_NON_EXPIRED` INT(11) NOT NULL COMMENT '密码未过期，1 未过期，0 过期，默认：1',

  `NAME` VARCHAR(200) NOT NULL COMMENT '姓名',
  `MEMO` VARCHAR(500) COMMENT '备注',
  `STATUS` VARCHAR(10) NOT NULL COMMENT '状态（1 启用，0 停用）',

  `MOBILE` VARCHAR(100) COMMENT '登录手机',
  `EMAIL` VARCHAR(100) COMMENT '登录邮箱',

  PRIMARY KEY (`ID`),
  UNIQUE KEY `UQ_USERNAME` (`USERNAME`)
)
COMMENT = '帐号表';


CREATE TABLE `TB_BASE_GROUP` (
  `ID` VARCHAR(100) NOT NULL COMMENT '',
  `COMPANY_ID` VARCHAR(100) COMMENT 'CompanyID',
  `DELETED` INT(1) COMMENT '是否删除',
  `ADD_ACCOUNT` VARCHAR(100) COMMENT '创建人',
  `ADD_TIME` DATETIME COMMENT '创建时间',
  `EDIT_ACCOUNT` VARCHAR(100) COMMENT '修改人',
  `EDIT_TIME` DATETIME COMMENT '修改时间',
  `DELETE_ACCOUNT` VARCHAR(100) COMMENT '删除人',
  `DELETE_TIME` DATETIME COMMENT '删除时间',

  `CODE` VARCHAR(200) NOT NULL COMMENT '代码',
  `NAME` VARCHAR(200) NOT NULL COMMENT '名称',
  `MEMO` VARCHAR(500) COMMENT '备注',
  `STATUS` VARCHAR(10) NOT NULL COMMENT '状态（1 启用，0 停用）',

  PRIMARY KEY (`ID`),
  UNIQUE KEY `UQ_CODE` (`COMPANY_ID`,`CODE`)
)
COMMENT = '用户组表';


CREATE TABLE `TB_BASE_ROLE` (
  `ID` VARCHAR(100) NOT NULL COMMENT '',
  `COMPANY_ID` VARCHAR(100) COMMENT 'CompanyID',
  `DELETED` INT(1) COMMENT '是否删除',
  `ADD_ACCOUNT` VARCHAR(100) COMMENT '创建人',
  `ADD_TIME` DATETIME COMMENT '创建时间',
  `EDIT_ACCOUNT` VARCHAR(100) COMMENT '修改人',
  `EDIT_TIME` DATETIME COMMENT '修改时间',
  `DELETE_ACCOUNT` VARCHAR(100) COMMENT '删除人',
  `DELETE_TIME` DATETIME COMMENT '删除时间',

  `CODE` VARCHAR(200) NOT NULL COMMENT '代码',
  `NAME` VARCHAR(200) NOT NULL COMMENT '名称',
  `MEMO` VARCHAR(500) COMMENT '备注',
  `STATUS` VARCHAR(10) NOT NULL COMMENT '状态（1 启用，0 停用）',

  PRIMARY KEY (`ID`),
  UNIQUE KEY `UQ_CODE` (`COMPANY_ID`,`CODE`)
)
COMMENT = '角色表';



CREATE TABLE `TB_BASE_ACCOUNT_GROUP` (
  `ID` VARCHAR(100) NOT NULL COMMENT '',
  `COMPANY_ID` VARCHAR(100) COMMENT 'CompanyID',
  `DELETED` INT(1) COMMENT '是否删除',
  `ADD_ACCOUNT` VARCHAR(100) COMMENT '创建人',
  `ADD_TIME` DATETIME COMMENT '创建时间',
  `EDIT_ACCOUNT` VARCHAR(100) COMMENT '修改人',
  `EDIT_TIME` DATETIME COMMENT '修改时间',
  `DELETE_ACCOUNT` VARCHAR(100) COMMENT '删除人',
  `DELETE_TIME` DATETIME COMMENT '删除时间',

  `ACCOUNT_ID` VARCHAR(200) NOT NULL COMMENT '帐号ID',
  `GROUP_ID` VARCHAR(200) NOT NULL COMMENT '用户组ID',

  PRIMARY KEY (`ID`)
)
COMMENT = '用户组 - 帐号关联表';



CREATE TABLE `TB_BASE_ACCOUNT_ROLE` (
  `ID` VARCHAR(100) NOT NULL COMMENT '',
  `COMPANY_ID` VARCHAR(100) COMMENT 'CompanyID',
  `DELETED` INT(1) COMMENT '是否删除',
  `ADD_ACCOUNT` VARCHAR(100) COMMENT '创建人',
  `ADD_TIME` DATETIME COMMENT '创建时间',
  `EDIT_ACCOUNT` VARCHAR(100) COMMENT '修改人',
  `EDIT_TIME` DATETIME COMMENT '修改时间',
  `DELETE_ACCOUNT` VARCHAR(100) COMMENT '删除人',
  `DELETE_TIME` DATETIME COMMENT '删除时间',

  `ACCOUNT_ID` VARCHAR(200) NOT NULL COMMENT '帐号ID',
  `ROLE_ID` VARCHAR(200) NOT NULL COMMENT '角色ID',

  PRIMARY KEY (`ID`)
)
COMMENT = '帐号 - 角色关联表';



CREATE TABLE `TB_BASE_GROUP_ROLE` (
  `ID` VARCHAR(100) NOT NULL COMMENT '',
  `COMPANY_ID` VARCHAR(100) COMMENT 'CompanyID',
  `DELETED` INT(1) COMMENT '是否删除',
  `ADD_ACCOUNT` VARCHAR(100) COMMENT '创建人',
  `ADD_TIME` DATETIME COMMENT '创建时间',
  `EDIT_ACCOUNT` VARCHAR(100) COMMENT '修改人',
  `EDIT_TIME` DATETIME COMMENT '修改时间',
  `DELETE_ACCOUNT` VARCHAR(100) COMMENT '删除人',
  `DELETE_TIME` DATETIME COMMENT '删除时间',

  `GROUP_ID` VARCHAR(200) NOT NULL COMMENT '用户组ID',
  `ROLE_ID` VARCHAR(200) NOT NULL COMMENT '角色ID',

  PRIMARY KEY (`ID`)
)
COMMENT = '用户组 - 角色关联表';



CREATE TABLE `TB_BASE_PERMISSION` (
  `ID` VARCHAR(100) NOT NULL COMMENT '',
  `COMPANY_ID` VARCHAR(100) COMMENT 'CompanyID',
  `DELETED` INT(1) COMMENT '是否删除',
  `ADD_ACCOUNT` VARCHAR(100) COMMENT '创建人',
  `ADD_TIME` DATETIME COMMENT '创建时间',
  `EDIT_ACCOUNT` VARCHAR(100) COMMENT '修改人',
  `EDIT_TIME` DATETIME COMMENT '修改时间',
  `DELETE_ACCOUNT` VARCHAR(100) COMMENT '删除人',
  `DELETE_TIME` DATETIME COMMENT '删除时间',

  `CODE` VARCHAR(200) NOT NULL COMMENT '代码',
  `NAME` VARCHAR(200) NOT NULL COMMENT '名称',
  `MEMO` VARCHAR(500) COMMENT '备注',
  `STATUS` VARCHAR(10) NOT NULL COMMENT '状态（1 启用，0 停用）',

  `TYPE_` VARCHAR(10) NOT NULL COMMENT '类型（1 应用，2 菜单，3 操作）',
  `URL` VARCHAR(500) COMMENT 'URL地址',

  `PARENT_ID` VARCHAR(100) NOT NULL COMMENT '父级ID', 
  `ORDER_` INT(11) NOT NULL COMMENT '排序',
  `LEVEL_` INT(11) NOT NULL COMMENT '层次',
  `LFT` INT(11) NOT NULL COMMENT '左索引',
  `RGT` INT(11) NOT NULL COMMENT '右索引',

  PRIMARY KEY (`ID`),
  UNIQUE KEY `UQ_CODE` (`COMPANY_ID`,`CODE`)
)
COMMENT = '权限表';



CREATE TABLE `TB_BASE_ROLE_PERMISSION` (
  `ID` VARCHAR(100) NOT NULL COMMENT '',
  `COMPANY_ID` VARCHAR(100) COMMENT 'CompanyID',
  `DELETED` INT(1) COMMENT '是否删除',
  `ADD_ACCOUNT` VARCHAR(100) COMMENT '创建人',
  `ADD_TIME` DATETIME COMMENT '创建时间',
  `EDIT_ACCOUNT` VARCHAR(100) COMMENT '修改人',
  `EDIT_TIME` DATETIME COMMENT '修改时间',
  `DELETE_ACCOUNT` VARCHAR(100) COMMENT '删除人',
  `DELETE_TIME` DATETIME COMMENT '删除时间',

  `ROLE_ID` VARCHAR(200) NOT NULL COMMENT '角色ID',
  `PERMISSION_ID` VARCHAR(200) NOT NULL COMMENT '权限ID',

  PRIMARY KEY (`ID`)
)
COMMENT = '角色 - 权限关联表';



CREATE TABLE `TB_BASE_RESOURCE` (
  `ID` VARCHAR(100) NOT NULL COMMENT '',
  `COMPANY_ID` VARCHAR(100) COMMENT 'CompanyID',
  `DELETED` INT(1) COMMENT '是否删除',
  `ADD_ACCOUNT` VARCHAR(100) COMMENT '创建人',
  `ADD_TIME` DATETIME COMMENT '创建时间',
  `EDIT_ACCOUNT` VARCHAR(100) COMMENT '修改人',
  `EDIT_TIME` DATETIME COMMENT '修改时间',
  `DELETE_ACCOUNT` VARCHAR(100) COMMENT '删除人',
  `DELETE_TIME` DATETIME COMMENT '删除时间',

  `CODE` VARCHAR(200) NOT NULL COMMENT '代码',
  `NAME` VARCHAR(200) NOT NULL COMMENT '名称',
  `MEMO` VARCHAR(500) COMMENT '备注',
  `STATUS` VARCHAR(10) NOT NULL COMMENT '状态（1 启用，0 停用）',

  `METHOD` VARCHAR(100) COMMENT '请求方式（GET、POST、PUT、DELETE 等）',
  `PATH` VARCHAR(500) COMMENT '请求地址',

  PRIMARY KEY (`ID`),
  UNIQUE KEY `UQ_CODE` (`COMPANY_ID`,`CODE`)
)
COMMENT = '资源（API）表';


CREATE TABLE `TB_BASE_PERMISSION_RESOURCE` (
  `ID` VARCHAR(100) NOT NULL COMMENT '',
  `COMPANY_ID` VARCHAR(100) COMMENT 'CompanyID',
  `DELETED` INT(1) COMMENT '是否删除',
  `ADD_ACCOUNT` VARCHAR(100) COMMENT '创建人',
  `ADD_TIME` DATETIME COMMENT '创建时间',
  `EDIT_ACCOUNT` VARCHAR(100) COMMENT '修改人',
  `EDIT_TIME` DATETIME COMMENT '修改时间',
  `DELETE_ACCOUNT` VARCHAR(100) COMMENT '删除人',
  `DELETE_TIME` DATETIME COMMENT '删除时间',

  `PERMISSION_ID` VARCHAR(200) NOT NULL COMMENT '权限ID',
  `RESOURCE_ID` VARCHAR(200) NOT NULL COMMENT '资源ID',

  PRIMARY KEY (`ID`)
)
COMMENT = '角色 - 权限关联表';



insert into TB_BASE_ACCOUNT (ID, DELETED, USERNAME, PASSWORD, ENABLED, ACCOUNT_NON_EXPIRED, ACCOUNT_NON_LOCKED, CREDENTIALS_NON_EXPIRED, NAME, STATUS) 
values ('1', 0, 'admin', 'admin', 1, 1, 1, 1, 'Admin', '1');

commit;


insert into TB_BASE_GROUP (ID, DELETED, CODE, NAME, STATUS) 
values ('1', 0, 'users', '所有用户', '1');

commit;


insert into TB_BASE_ROLE (ID, DELETED, CODE, NAME, STATUS) 
values ('1', 0, 'administrator', '超级管理员', '1');
insert into TB_BASE_ROLE (ID, DELETED, CODE, NAME, STATUS) 
values ('2', 0, 'user', '普通用户', '1');

commit;


insert into TB_BASE_ACCOUNT_GROUP (ID, DELETED, ACCOUNT_ID, GROUP_ID) 
values ('1_1', 0, '1', '1');

commit;


insert into TB_BASE_ACCOUNT_ROLE (ID, DELETED, ACCOUNT_ID, ROLE_ID) 
values ('1_1', 0, '1', '1');

insert into TB_BASE_ACCOUNT_ROLE (ID, DELETED, ACCOUNT_ID, ROLE_ID) 
values ('1_2', 0, '1', '2');

commit;


insert into TB_BASE_GROUP_ROLE (ID, DELETED, GROUP_ID, ROLE_ID) 
values ('1', 0, '1', '2');

commit;


insert into TB_BASE_PERMISSION (ID, DELETED, CODE, NAME, STATUS, TYPE_, URL, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('1', 0, 'admin', '树维管理后台', '1', '1', '', '0', 1, 1, 1, 10);

insert into TB_BASE_PERMISSION (ID, DELETED, CODE, NAME, STATUS, TYPE_, URL, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('10000', 0, 'admin.base', '基础管理', '1', '2', '', '1', 10000, 1, 1, 14);

insert into TB_BASE_PERMISSION (ID, DELETED, CODE, NAME, STATUS, TYPE_, URL, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('10100', 0, 'admin.base.account', '帐号管理', '1', '2', '', '10000', 10100, 2, 2, 3);
insert into TB_BASE_PERMISSION (ID, DELETED, CODE, NAME, STATUS, TYPE_, URL, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('10200', 0, 'admin.base.group', '用户组管理', '1', '2', '', '10000', 10200, 2, 4, 5);
insert into TB_BASE_PERMISSION (ID, DELETED, CODE, NAME, STATUS, TYPE_, URL, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('10300', 0, 'admin.base.role', '角色管理', '1', '2', '', '10000', 10300, 2, 6, 7);
insert into TB_BASE_PERMISSION (ID, DELETED, CODE, NAME, STATUS, TYPE_, URL, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('10400', 0, 'admin.base.menu', '菜单管理', '1', '2', '', '10000', 10400, 2, 8, 9);
insert into TB_BASE_PERMISSION (ID, DELETED, CODE, NAME, STATUS, TYPE_, URL, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('10500', 0, 'admin.base.operation', '操作管理', '1', '2', '', '10000', 10500, 2, 10, 11);
insert into TB_BASE_PERMISSION (ID, DELETED, CODE, NAME, STATUS, TYPE_, URL, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('10600', 0, 'admin.base.resource', '资源管理', '1', '2', '', '10000', 10600, 2, 12, 13);

insert into TB_BASE_PERMISSION (ID, DELETED, CODE, NAME, STATUS, TYPE_, URL, PARENT_ID, ORDER_, LEVEL_, LFT, RGT) 
values ('20000', 0, 'admin.system', '系统管理', '1', '2', '', '1', 20000, 1, 1, 14);

commit;


/** 超级管理员角色的权限 */
insert into TB_BASE_ROLE_PERMISSION (ID, DELETED, ROLE_ID, PERMISSION_ID) 
select CONCAT('1_', ID), 0, '1', ID from TB_BASE_PERMISSION;

/** 普通用户角色的权限 */
insert into TB_BASE_ROLE_PERMISSION (ID, DELETED, ROLE_ID, PERMISSION_ID) 
values ('2_1', 0, '2', '1');

commit;




insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10101', 0, 'BaseAdminAccount.query', '查询帐号', '1', 'GET', '/api/base/v1/admin/accounts');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10102', 0, 'BaseAdminAccount.load', '获取帐号', '1', 'GET', '/api/base/v1/admin/accounts/{id}');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10103', 0, 'BaseAdminAccount.create', '创建帐号', '1', 'POST', '/api/base/v1/admin/accounts');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10104', 0, 'BaseAdminAccount.update', '修改帐号', '1', 'PUT', '/api/base/v1/admin/accounts/{id}');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10105', 0, 'BaseAdminAccount.delete', '删除帐号', '1', 'DELETE', '/api/base/v1/admin/accounts/{id}');

insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10106', 0, 'BaseAdminAccount.accountGroups', '获取帐号的用户组', '1', 'GET', '/api/base/v1/admin/accounts/{id}/groups');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10107', 0, 'BaseAdminAccount.relateGroups', '关联帐号的用户组', '1', 'POST', '/api/base/v1/admin/accounts/{id}/groups');

insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10108', 0, 'BaseAdminAccount.accountRoles', '获取帐号的角色', '1', 'GET', '/api/base/v1/admin/accounts/{id}/roles');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10109', 0, 'BaseAdminAccount.relateRoles', '关联帐号的角色', '1', 'POST', '/api/base/v1/admin/accounts/{id}/roles');



insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10201', 0, 'BaseAdminGroup.query', '查询用户组', '1', 'GET', '/api/base/v1/admin/groups');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10202', 0, 'BaseAdminGroup.load', '获取用户组', '1', 'GET', '/api/base/v1/admin/groups/{id}');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10203', 0, 'BaseAdminGroup.create', '创建用户组', '1', 'POST', '/api/base/v1/admin/groups');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10204', 0, 'BaseAdminGroup.update', '修改用户组', '1', 'PUT', '/api/base/v1/admin/groups/{id}');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10205', 0, 'BaseAdminGroup.delete', '删除用户组', '1', 'DELETE', '/api/base/v1/admin/groups/{id}');

insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10206', 0, 'BaseAdminGroup.groupAccounts', '获取用户组的帐号', '1', 'GET', '/api/base/v1/admin/groups/{id}/accounts');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10207', 0, 'BaseAdminGroup.relateAccounts', '关联用户组的帐号', '1', 'POST', '/api/base/v1/admin/groups/{id}/accounts');

insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10208', 0, 'BaseAdminGroup.groupRoles', '获取用户组的角色', '1', 'GET', '/api/base/v1/admin/groups/{id}/roles');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10209', 0, 'BaseAdminGroup.relateRoles', '关联用户组的角色', '1', 'POST', '/api/base/v1/admin/groups/{id}/roles');



insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10301', 0, 'BaseAdminRole.query', '查询角色', '1', 'GET', '/api/base/v1/admin/roles');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10302', 0, 'BaseAdminRole.load', '获取角色', '1', 'GET', '/api/base/v1/admin/roles/{id}');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10303', 0, 'BaseAdminRole.create', '创建角色', '1', 'POST', '/api/base/v1/admin/roles');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10304', 0, 'BaseAdminRole.update', '修改角色', '1', 'PUT', '/api/base/v1/admin/roles/{id}');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10305', 0, 'BaseAdminRole.delete', '删除角色', '1', 'DELETE', '/api/base/v1/admin/roles/{id}');

insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10306', 0, 'BaseAdminRole.roleAccounts', '获取角色的帐号', '1', 'GET', '/api/base/v1/admin/roles/{id}/accounts');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10307', 0, 'BaseAdminRole.relateAccounts', '关联角色的帐号', '1', 'POST', '/api/base/v1/admin/roles/{id}/accounts');

insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10308', 0, 'BaseAdminRole.roleGroups', '获取角色的用户组', '1', 'GET', '/api/base/v1/admin/roles/{id}/groups');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10309', 0, 'BaseAdminRole.relateGroups', '关联角色的用户组', '1', 'POST', '/api/base/v1/admin/roles/{id}/groups');

insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10310', 0, 'BaseAdminRole.rolePermissions', '获取角色的权限', '1', 'GET', '/api/base/v1/admin/roles/{id}/permissions');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10311', 0, 'BaseAdminRole.relatePermissions', '关联角色的权限', '1', 'POST', '/api/base/v1/admin/roles/{id}/permissions');



insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10401', 0, 'BaseAdminMenu.query', '查询菜单', '1', 'GET', '/api/base/v1/admin/menus');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10402', 0, 'BaseAdminMenu.load', '获取菜单', '1', 'GET', '/api/base/v1/admin/menus/{id}');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10403', 0, 'BaseAdminMenu.create', '创建菜单', '1', 'POST', '/api/base/v1/admin/menus');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10404', 0, 'BaseAdminMenu.update', '修改菜单', '1', 'PUT', '/api/base/v1/admin/menus/{id}');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10405', 0, 'BaseAdminMenu.delete', '删除菜单', '1', 'DELETE', '/api/base/v1/admin/menus/{id}');

insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10406', 0, 'BaseAdminMenu.tree', '树形菜单', '1', 'GET', '/api/base/v1/admin/menus/tree');



insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10501', 0, 'BaseAdminOperation.query', '查询操作', '1', 'GET', '/api/base/v1/admin/operations');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10502', 0, 'BaseAdminOperation.load', '获取操作', '1', 'GET', '/api/base/v1/admin/operations/{id}');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10503', 0, 'BaseAdminOperation.create', '创建操作', '1', 'POST', '/api/base/v1/admin/operations');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10504', 0, 'BaseAdminOperation.update', '修改操作', '1', 'PUT', '/api/base/v1/admin/operations/{id}');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10505', 0, 'BaseAdminOperation.delete', '删除操作', '1', 'DELETE', '/api/base/v1/admin/operations/{id}');



insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10601', 0, 'BaseAdminResource.query', '查询资源', '1', 'GET', '/api/base/v1/admin/resources');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10602', 0, 'BaseAdminResource.load', '获取资源', '1', 'GET', '/api/base/v1/admin/resources/{id}');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10603', 0, 'BaseAdminResource.create', '创建资源', '1', 'POST', '/api/base/v1/admin/resources');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10604', 0, 'BaseAdminResource.update', '修改资源', '1', 'PUT', '/api/base/v1/admin/resources/{id}');
insert into TB_BASE_RESOURCE (ID, DELETED, CODE, NAME, STATUS, METHOD, PATH)
values ('10605', 0, 'BaseAdminResource.delete', '删除资源', '1', 'DELETE', '/api/system/v1/admin/resources/{id}');

