package com.supwisdom.institute.backend.common.framework.exception;

public class BaseException extends RuntimeException {

  /**
   * 
   */
  private static final long serialVersionUID = 2278568118369300446L;
  
  public static final int DEFAULT_CODE = -1;

  /**
   * 具体异常码
   */
  protected final int code;
  
  private final String messageCode;

  @Deprecated
  public BaseException(int code, String msgFormat, Object... args) {
      super(String.format(msgFormat, args));
      this.code = code;
      this.messageCode = null;
  }
  
  public BaseException(int code, String messageCode, String msgFormat, Object... args) {
    super(String.format(msgFormat, args));
    this.code = code;
    this.messageCode = messageCode;
}

  public BaseException() {
    super();
    this.code = DEFAULT_CODE;
    this.messageCode = null;
  }

  public BaseException(String message, Throwable cause) {
      super(message, cause);
      this.code = DEFAULT_CODE;
      this.messageCode = null;
  }

  public BaseException(Throwable cause) {
      super(cause);
      this.code = DEFAULT_CODE;
      this.messageCode = null;
  }

  public BaseException(String message) {
      super(message);
      this.code = DEFAULT_CODE;
      this.messageCode = null;
  }

  public int getCode() {
      return code;
  }

  /**
   * 实例化异常
   * 
   * @param msgFormat
   * @param args
   * @return
   */
  @Deprecated
  public static BaseException newInstance(String msgFormat, Object... args) {
      return new BaseException(DEFAULT_CODE, msgFormat, args);
  }
  
  @Deprecated
  public static BaseException newInstance(int code, String msgFormat, Object... args) {
    return new BaseException(code, msgFormat, args);
  }
  
  public static BaseException newInstance(int code, String messageCode, String msgFormat, Object... args) {
    return new BaseException(code, messageCode, msgFormat, args);
  }

}
