package com.supwisdom.institute.backend.common.framework.vo.response.data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

public interface IApiQueryResponseData<E extends Serializable> extends IApiResponseData {
  
  /**
   * 当前页码
   * @return
   */
  int getPageIndex();
  
  /**
   * 每页记录数
   * @return
   */
  int getPageSize();
  
  /**
   * 查询条件
   * @return
   */
  Map<String, Object> getMapBean();
  
  /**
   * 排序字段
   * @return
   */
  Map<String, String> getOrderBy();
  
  /**
   * 总页数
   * @return
   */
  int getPageCount();
  
  /**
   * 总记录数
   * @return
   */
  long getRecordCount();
  
  /**
   * 返回记录数
   * @return
   */
  int getCurrentItemCount();
  
  /**
   * 返回记录
   * @return
   */
  List<E> getItems();
  
}
