package com.supwisdom.institute.backend.common.core.distributedlock;

import lombok.extern.slf4j.Slf4j;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Slf4j
@Configuration
public class DistributedLockAutoConfiguration {
  
  @Bean
  @ConditionalOnMissingBean(DistributedLockHandler.class)
  public DistributedLockHandler defaultDistributedLockHandler() {
    DistributedLockHandler defaultDistributedLockHandler = new DefaultDistributedLockHandler();
    log.debug("DistributedLockAutoConfiguration.defaultDistributedLockHandler is {}", defaultDistributedLockHandler);

    return defaultDistributedLockHandler;
  }
}
