package com.supwisdom.institute.backend.common.core.distributedlock;

public interface DistributedLockHandler {
  public static final long TIMEOUT_MILLIS = 30000;

  public static final int RETRY_TIMES = Integer.MIN_VALUE;

  public static final long SLEEP_MILLIS = 500;

  /**
   * 获取锁<br>
   * 超时：30000 ms (30 s) {@link DistributedLockHandler.TIMEOUT_MILLIS}<br>
   * 重试次数：不重试 {@link DistributedLockHandler.RETRY_TIMES}<br>
   * 重试等待：500 ms {@link DistributedLockHandler.SLEEP_MILLIS}<br>
   * <br>
   * @param key
   * @return
   */
  public boolean lock(String key);

  /**
   * 获取锁<br>
   * 超时：30000 ms (30 s) {@link DistributedLockHandler.TIMEOUT_MILLIS}<br>
   * 重试等待：500 ms {@link DistributedLockHandler.SLEEP_MILLIS}<br>
   * <br>
   * @param key
   * @param retryTimes 重试次数
   * @return
   */
  public boolean lock(String key, int retryTimes);

  /**
   * 获取锁<br>
   * 超时：30000 ms (30 s) {@link DistributedLockHandler.TIMEOUT_MILLIS}<br>
   * <br>
   * @param key
   * @param retryTimes 重试次数
   * @param sleepMillis 重试等待 单位 ms
   * @return
   */
  public boolean lock(String key, int retryTimes, long sleepMillis);

  /**
   * 获取锁<br>
   * 重试次数：不重试 {@link DistributedLockHandler.RETRY_TIMES}<br>
   * 重试等待：500 ms {@link DistributedLockHandler.SLEEP_MILLIS}<br>
   * <br>
   * @param key
   * @param expire 超时 单位 ms
   * @return
   */
  public boolean lock(String key, long expire);

  /**
   * 获取锁<br>
   * 重试等待：500 ms {@link DistributedLockHandler.SLEEP_MILLIS}<br>
   * <br>
   * @param key
   * @param retryTimes 重试次数
   * @param expire 超时 单位 ms
   * @return
   */
  public boolean lock(String key, long expire, int retryTimes);

  /**
   * 获取锁<br>
   * <br>
   * @param key
   * @param expire 超时 单位 ms
   * @param retryTimes 重试次数
   * @param sleepMillis 重试等待 单位 ms
   * @return
   */
  public boolean lock(String key, long expire, int retryTimes, long sleepMillis);

  /**
   * 释放锁<br>
   * <br>
   * @param key
   * @return
   */
  public boolean releaseLock(String key);
}
