package com.supwisdom.institute.backend.gateway.filter;

import java.util.Optional;

import lombok.extern.slf4j.Slf4j;

import org.apache.commons.codec.binary.Base64;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.core.Ordered;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.web.server.ServerWebExchange;

import com.alibaba.fastjson.JSONObject;
import com.supwisdom.infras.security.core.userdetails.InfrasUser;
import com.supwisdom.institute.backend.common.core.transmit.user.User;
import com.supwisdom.institute.backend.common.core.transmit.user.UserContext;

import reactor.core.publisher.Mono;

@Slf4j
public class SimpleUserTransmitGlobalFilter implements GlobalFilter, Ordered {

  @Override
  public int getOrder() {
    return 0;
  }

  @Override
  public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
    log.debug("SimpleUserTransmitGlobalFilter.filter");
    
    return ReactiveSecurityContextHolder.getContext()
      .filter(c -> {
        return c.getAuthentication() != null && c.getAuthentication().isAuthenticated() && c.getAuthentication().getPrincipal() instanceof InfrasUser;
      })
      .flatMap(sc -> Mono.just(Optional.of(sc)))
      .defaultIfEmpty(Optional.empty())
      .flatMap(scOptional -> {
        if (scOptional.isPresent()) {
          SecurityContext sc = scOptional.get();
          
          return Mono.just(sc)
            .map(SecurityContext::getAuthentication)
            .map(Authentication::getPrincipal)
            .cast(InfrasUser.class)
            .map(infrasUser -> {
              try {
                User user = new User(infrasUser.getUsername(), infrasUser.getRoles(), infrasUser.getAttributes());
                
                String jsonUser = JSONObject.toJSONString(user);
                log.debug(jsonUser);
                
                //String headerValue = new String(URLDecoder.decode(jsonUser,"UTF-8"));
                String headerValue = Base64.encodeBase64URLSafeString(jsonUser.getBytes("UTF-8"));
                log.debug(headerValue);
                
                ServerHttpRequest request = exchange.getRequest().mutate()
                    .header(UserContext.KEY_USER_IN_HTTP_HEADER, headerValue)
                    .build();
                log.debug("User set to gateway header: ok");
                return exchange.mutate().request(request).build();
              } catch (Exception e) {
                log.warn("User set to gateway header: error", e);
              }
              return exchange;
            });
        }
        
        return Mono.just(exchange);
      })
      .flatMap(ex -> chain.filter(ex))
    ;
  }

}
