package com.supwisdom.institute.backend.gateway.security.core.userdetails;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.ReactiveUserDetailsService;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.password.PasswordEncoder;

import com.supwisdom.institute.backend.common.core.transmit.user.User;
import com.supwisdom.institute.backend.common.core.transmit.user.UserContext;

import reactor.core.publisher.Mono;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class InMemeryUserDetailsService implements UserDetailsService, ReactiveUserDetailsService {

  @Autowired
  PasswordEncoder passwordEncoder;
  
  @Override
  public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
    
    log.debug("InMemeryUserDetailsService.loadUserByUsername({})", username);
    
    List<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
    authorities.add(new SimpleGrantedAuthority("ROLE_ADMIN"));
    authorities.add(new SimpleGrantedAuthority("administrator"));
    authorities.add(new SimpleGrantedAuthority("user"));

    Map<String, Object> attributes = new HashMap<String, Object>();
    
    MyUser myUser = new MyUser(username, passwordEncoder.encode(username), authorities, attributes);
    log.debug("myUser is {}", myUser);
    
    return myUser;
  }

  @Override
  public Mono<UserDetails> findByUsername(String username) {

    log.debug("InMemeryUserDetailsService.findByUsername({})", username);
    
    List<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
    authorities.add(new SimpleGrantedAuthority("ROLE_ADMIN"));
    authorities.add(new SimpleGrantedAuthority("administrator"));
    authorities.add(new SimpleGrantedAuthority("user"));

    Map<String, Object> attributes = new HashMap<String, Object>();
    
    MyUser myUser = new MyUser(username, passwordEncoder.encode(username), authorities, attributes);
    log.debug("myUser is {}", myUser);
    
    List<String> roles = new ArrayList<>();
    roles.add("ROLE_ADMIN");
    roles.add("administrator");
    roles.add("user");
    User user = new User(username, roles, attributes);
    UserContext.setUser(user);
    
    return Mono.just(myUser);
  }
  
}
