package com.supwisdom.institute.backend.base.api.vo.response;

import lombok.Getter;
import lombok.Setter;

import java.util.List;
import java.util.Map;

import org.springframework.data.domain.Page;

import com.supwisdom.institute.backend.base.domain.entity.AccountGroup;
import com.supwisdom.institute.backend.common.framework.vo.request.IApiQueryRequest;
import com.supwisdom.institute.backend.common.framework.vo.response.data.IApiQueryResponseData;

/**
 * @author loie
 */
public class GroupRelatedAccountsResponseData implements IApiQueryResponseData<AccountGroup> {

  /**
   * 
   */
  private static final long serialVersionUID = -6697630069320874813L;

  private GroupRelatedAccountsResponseData(boolean loadAll, int pageIndex, int pageSize, Map<String, Object> mapBean, Map<String, String> orderBy) {
    this.loadAll = loadAll;
    this.pageIndex = pageIndex;
    this.pageSize = pageSize;
    this.mapBean = mapBean;
    this.orderBy = orderBy;
  }

  public static GroupRelatedAccountsResponseData of(IApiQueryRequest queryRequest) {
    GroupRelatedAccountsResponseData configQueryResponse = new GroupRelatedAccountsResponseData(
        queryRequest.isLoadAll(), 
        queryRequest.getPageIndex(), 
        queryRequest.getPageSize(), 
        queryRequest.getMapBean(), 
        queryRequest.getOrderBy()
    );
    
    return configQueryResponse;
  }
  
  public GroupRelatedAccountsResponseData build(Page<AccountGroup> page) {
    this.currentItemCount = page.getNumberOfElements();
    this.pageCount = page.getTotalPages();
    this.recordCount = page.getTotalElements();
    this.items = page.getContent();

    return this;
  }

  @Getter
  private boolean loadAll;
  @Getter
  private int pageIndex;
  @Getter
  private int pageSize;
  @Getter
  private Map<String, Object> mapBean;
  @Getter
  private Map<String, String> orderBy;
  
  @Getter
  @Setter
  private int pageCount;
  @Getter
  @Setter
  private long recordCount;
  
  @Getter
  @Setter
  private int currentItemCount;
  
  @Getter
  @Setter
  private List<AccountGroup> items;
  
}
