package com.supwisdom.institute.backend.base.domain.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import com.supwisdom.institute.backend.common.framework.entity.ABaseEntity;

@Entity
@Table(name = "TB_U_ACCOUNT")
public class Account extends ABaseEntity {

  /**
   * 
   */
  private static final long serialVersionUID = 7955624268022038897L;
  
  public static final String STATUS_ENABLED = "1";
  public static final String STATUS_DISABLED = "0";
  

  /**
   * 用户名
   */
  @Column(name = "USERNAME", unique = true)
  private String username;
  
  /**
   * 密码
   */
  @Column(name = "PASSWORD")
  private String password;

  /**
   * 是否可用，1 可用，0 不可用，默认：1
   */
  @Column(name = "ENABLED")
  private Boolean enabled;
  /**
   * 账号未过期，1 未过期，0 过期，默认：1
   */
  @Column(name = "ACCOUNT_NON_EXPIRED")
  private Boolean accountNonExpired;
  /**
   * 账号未锁定，1 未锁定，0 锁定，默认：1
   */
  @Column(name = "ACCOUNT_NON_LOCKED")
  private Boolean accountNonLocked;
  /**
   * 密码未过期，1 未过期，0 过期，默认：1
   */
  @Column(name = "CREDENTIALS_NON_EXPIRED")
  private Boolean credentialsNonExpired;

  /**
   * 姓名
   */
  @Column(name = "NAME")
  private String name;

  /**
   * 备注
   */
  @Column(name = "MEMO")
  private String memo;

  /**
   * 状态（1 启用，0 停用）
   */
  @Column(name = "STATUS")
  private String status;

  /**
   * 登录手机
   */
  @Column(name = "MOBILE", nullable = true)
  private String mobile;
  /**
   * 登录邮箱
   */
  @Column(name = "EMAIL", nullable = true)
  private String email;

  public String getUsername() {
    return username;
  }

  public void setUsername(String username) {
    this.username = username;
  }

  public String getPassword() {
    return password;
  }

  public void setPassword(String password) {
    this.password = password;
  }

  public Boolean getEnabled() {
    return enabled;
  }

  public void setEnabled(Boolean enabled) {
    this.enabled = enabled;
  }

  public Boolean getAccountNonExpired() {
    return accountNonExpired;
  }

  public void setAccountNonExpired(Boolean accountNonExpired) {
    this.accountNonExpired = accountNonExpired;
  }

  public Boolean getAccountNonLocked() {
    return accountNonLocked;
  }

  public void setAccountNonLocked(Boolean accountNonLocked) {
    this.accountNonLocked = accountNonLocked;
  }

  public Boolean getCredentialsNonExpired() {
    return credentialsNonExpired;
  }

  public void setCredentialsNonExpired(Boolean credentialsNonExpired) {
    this.credentialsNonExpired = credentialsNonExpired;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  public String getMobile() {
    return mobile;
  }

  public void setMobile(String mobile) {
    this.mobile = mobile;
  }

  public String getEmail() {
    return email;
  }

  public void setEmail(String email) {
    this.email = email;
  }

}
