package com.supwisdom.institute.backend.base.domain.repo;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Repository;

import com.supwisdom.institute.backend.base.domain.entity.Permission;
import com.supwisdom.institute.backend.base.domain.entity.PermissionResource;
import com.supwisdom.institute.backend.base.domain.entity.Resource;
import com.supwisdom.institute.backend.common.framework.repo.BaseJpaRepository;
import com.supwisdom.institute.backend.common.util.MapBeanUtils;

@Repository
public interface PermissionResourceRepository extends BaseJpaRepository<PermissionResource> {

  public default Page<PermissionResource> selectPageList(int pageIndex, int pageSize, Map<String, Object> mapBean) {
    PermissionResource probe = new PermissionResource();
    if (mapBean != null) {
      probe.setPermissionId(MapBeanUtils.getString(mapBean, "permissionId"));
      probe.setResourceId(MapBeanUtils.getString(mapBean, "resourceId"));
    }

    ExampleMatcher matcher = ExampleMatcher.matching()
        .withMatcher("permissionId", ExampleMatcher.GenericPropertyMatchers.exact())
        .withMatcher("resourceId", ExampleMatcher.GenericPropertyMatchers.exact());

    PageRequest pageRequest = PageRequest.of(pageIndex, pageSize);
    Example<PermissionResource> example = Example.of(probe, matcher);

    Page<PermissionResource> page = this.findAll(example, pageRequest);

    return page;
  }

  public default Page<PermissionResource> selectPermissionResources(int pageIndex, int pageSize, Map<String, Object> mapBean) {

    PermissionResource probe = new PermissionResource();
    if (mapBean != null) {
      probe.setPermissionId(MapBeanUtils.getString(mapBean, "permissionId"));
      probe.setResourceId(MapBeanUtils.getString(mapBean, "resourceId"));
    }

    ExampleMatcher matcher = ExampleMatcher.matching()
        .withMatcher("permissionId", ExampleMatcher.GenericPropertyMatchers.exact())
        .withMatcher("resourceId", ExampleMatcher.GenericPropertyMatchers.exact());

    Example<PermissionResource> example = Example.of(probe, matcher);

    PageRequest pageRequest = PageRequest.of(pageIndex, pageSize);

    Page<PermissionResource> page = this.findAll(example, pageRequest); // FIXME: 多表关联查询

    return page;
  }

  public default void relatePermissionResources(Permission permission, List<PermissionResource> relateResources) {

    List<PermissionResource> existPermissionResources = this.selectListByPermissionId(permission.getId());

    Map<String, PermissionResource> existMapPermissionResources = new LinkedHashMap<String, PermissionResource>();
    for (PermissionResource permissionResource : existPermissionResources) {
      String k = String.format("%s", permissionResource.getResourceId());
      existMapPermissionResources.put(k, permissionResource);
    }

    for (PermissionResource permissionResource : relateResources) {
      String k = String.format("%s", permissionResource.getResourceId());

      if (existMapPermissionResources.containsKey(k)) {
        existMapPermissionResources.remove(k);
      } else {
        permissionResource.setCompanyId(permission.getCompanyId());
        permissionResource.setPermissionId(permission.getId());

        this.insert(permissionResource);
      }
    }

    for (PermissionResource rolePermission : existMapPermissionResources.values()) {
      this.deleteById(rolePermission.getId());
    }
  }

  public default List<PermissionResource> selectListByPermissionId(String permissionId) {

    PermissionResource probe = new PermissionResource();
    probe.setPermissionId(permissionId);

    ExampleMatcher matcher = ExampleMatcher.matching().withMatcher("permissionId",
        ExampleMatcher.GenericPropertyMatchers.exact());

    Example<PermissionResource> example = Example.of(probe, matcher);

    List<PermissionResource> rolePermissions = this.findAll(example);

    return rolePermissions;
  }

  
  public default void relateResourcePermissions(Resource resource, List<PermissionResource> relatePermissions) {

    // 获取权限已关联的角色
    List<PermissionResource> existResourcePermissions = this.selectListByResourceId(resource.getId());

    Map<String, PermissionResource> existMapResourcePermissions = new LinkedHashMap<String, PermissionResource>();
    for (PermissionResource permissionResource : existResourcePermissions) {
      String k = String.format("%s", permissionResource.getPermissionId());
      existMapResourcePermissions.put(k, permissionResource);
    }

    // 保存未关联的角色
    for (PermissionResource permissionResource : relatePermissions) {
      String k = String.format("%s", permissionResource.getPermissionId());

      if (existMapResourcePermissions.containsKey(k)) {
        existMapResourcePermissions.remove(k);
      } else {
        permissionResource.setCompanyId(resource.getCompanyId());
        permissionResource.setResourceId(resource.getId());

        this.insert(permissionResource);
      }
    }

    // 删除移除关联的角色
    for (PermissionResource rolePermission : existMapResourcePermissions.values()) {
      this.deleteById(rolePermission.getId());
    }
  }
  public default List<PermissionResource> selectListByResourceId(String resourceId) {

    PermissionResource probe = new PermissionResource();
    probe.setResourceId(resourceId);

    ExampleMatcher matcher = ExampleMatcher.matching().withMatcher("resourceId",
        ExampleMatcher.GenericPropertyMatchers.exact());

    Example<PermissionResource> example = Example.of(probe, matcher);

    List<PermissionResource> rolePermissions = this.findAll(example);

    return rolePermissions;
  }

  
  public default PermissionResource selectOneByPermissionResource(String permissionId, String resourceId) {

    PermissionResource probe = new PermissionResource();
    probe.setPermissionId(permissionId);
    probe.setResourceId(resourceId);

    ExampleMatcher matcher = ExampleMatcher.matching()
        .withMatcher("permissionId", ExampleMatcher.GenericPropertyMatchers.exact())
        .withMatcher("resourceId", ExampleMatcher.GenericPropertyMatchers.exact())
        ;

    Example<PermissionResource> example = Example.of(probe, matcher);
    
    Optional<PermissionResource> o = this.findOne(example);
    
    return o.isPresent() ? o.get() : null;
  }

  public default void addPermissionResource(String permissionId, String resourceId) {

    PermissionResource rolePermission = this.selectOneByPermissionResource(permissionId, resourceId);
    
    if (rolePermission == null) {
      rolePermission = new PermissionResource();
      //rolePermission.setCompanyId(companyId);
      rolePermission.setPermissionId(permissionId);
      rolePermission.setResourceId(resourceId);
      
      this.insert(rolePermission);
    }
  }

  public default void removePermissionResource(String permissionId, String resourceId) {

    PermissionResource rolePermission = this.selectOneByPermissionResource(permissionId, resourceId);
    
    if (rolePermission != null) {
      this.deleteById(rolePermission.getId());
    }
  }

}
