package com.supwisdom.institute.backend.common.framework.exception;

import lombok.Getter;
import lombok.Setter;

import com.supwisdom.institute.backend.common.framework.vo.response.data.IApiResponseData;

public class ErrorResponse implements IApiResponseData {

  /**
   * 
   */
  private static final long serialVersionUID = 5810078993746894780L;

  /**
   * 异常信息
   */
  @Getter
  @Setter
  private String message;

  /**
   * 具体异常码
   */
  @Getter
  @Setter
  private int code = -1;

  private ErrorResponse(int code, String msgFormat, Object... args) {
    this.code = code;
    this.message = String.format(msgFormat, args);
  }

  public static ErrorResponse of(int code, String msgFormat, Object... args) {
    return new ErrorResponse(code, msgFormat, args);
  }

}
