package com.supwisdom.institute.backend.common.framework.repo;

import java.util.Calendar;
import java.util.Map;
import java.util.Optional;

import javax.persistence.EntityManager;
import javax.transaction.Transactional;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.data.repository.NoRepositoryBean;

import com.supwisdom.institute.backend.common.core.transmit.user.UserContext;
import com.supwisdom.institute.backend.common.framework.entity.ABaseEntity;

@Transactional
@NoRepositoryBean
public class ABaseJpaRepository<E extends ABaseEntity> extends SimpleJpaRepository<E, String> implements BaseJpaRepository<E> {

  @SuppressWarnings("unused")
  private final EntityManager em;

  public ABaseJpaRepository(Class<E> domainClass, EntityManager em) {
    super(domainClass, em);
    this.em = em;
  }

  public ABaseJpaRepository(JpaEntityInformation<E, String> information, EntityManager em) {
    super(information, em);
    this.em = em;
  }
  
  public Page<E> selectPageList(int pageIndex, int pageSize, Map<String, Object> mapBean) {

    PageRequest pageRequest = PageRequest.of(pageIndex, pageSize);

    Page<E> page = this.findAll(pageRequest);

    return page;
  }

  public E selectById(String id) {

    try {
      Optional<E> entity = this.findById(id);

      if (entity.isPresent()) {
        return entity.get();
      }
    } catch (RuntimeException e) {
      System.out.println("RuntimeException:" + e.getMessage());
    } catch (Exception e) {
      System.out.println("Exception:" + e.getMessage());
    }

    return null;
  }

  public E insert(E entity) {

    if (entity.getCompanyId() == null || entity.getCompanyId().isEmpty()) {
      entity.setCompanyId("1");
    }

    if (entity.getDeleted() == null) {
      entity.setDeleted(false);
    }
    if (entity.getAddAccount() == null) {
      entity.setAddAccount(UserContext.getUsername());
    }
    if (entity.getAddTime() == null) {
      entity.setAddTime(Calendar.getInstance().getTime());
    }

    E e = this.save(entity);

    return e;
  }

  public E update(E entity) {

    if (entity.getEditAccount() == null) {
      entity.setEditAccount(UserContext.getUsername());
    }
    if (entity.getEditTime() == null) {
      entity.setEditTime(Calendar.getInstance().getTime());
    }
    
    E e = this.save(entity);

    return e;
  }
  
  public E remove(E entity) {
    
    if (entity.getDeleted() == null) {
      entity.setDeleted(true);
    }
    if (entity.getDeleteAccount() == null) {
      entity.setDeleteAccount(UserContext.getUsername());
    }
    if (entity.getDeleteTime() == null) {
      entity.setDeleteTime(Calendar.getInstance().getTime());
    }
    
    E e = this.save(entity);
    
    return e;
  }

}
