package com.supwisdom.institute.backend.biz.api.vo.response;

import lombok.Getter;
import lombok.Setter;

import java.util.List;
import java.util.Map;

import org.springframework.data.domain.Page;

import com.supwisdom.institute.backend.biz.api.vo.request.BizQueryRequest;
import com.supwisdom.institute.backend.biz.domain.entity.Biz;
import com.supwisdom.institute.backend.common.framework.vo.response.data.IApiQueryResponseData;

/**
 * @author loie
 */
public class BizQueryResponseData implements IApiQueryResponseData<Biz> {

  /**
   * 
   */
  private static final long serialVersionUID = 5706417972093485886L;
  
  private BizQueryResponseData(boolean loadAll, int pageIndex, int pageSize, Map<String, Object> mapBean, Map<String, String> orderBy) {
    this.loadAll = loadAll;
    this.pageIndex = pageIndex;
    this.pageSize = pageSize;
    this.mapBean = mapBean;
    this.orderBy = orderBy;
  }

  public static BizQueryResponseData of(BizQueryRequest queryRequest) {
    BizQueryResponseData data = new BizQueryResponseData(
        queryRequest.isLoadAll(), 
        queryRequest.getPageIndex(), 
        queryRequest.getPageSize(), 
        queryRequest.getMapBean(), 
        queryRequest.getOrderBy()
    );
    
    return data;
  }
  
  public BizQueryResponseData build(Page<Biz> page) {
    this.currentItemCount = page.getNumberOfElements();
    this.pageCount = page.getTotalPages();
    this.recordCount = page.getTotalElements();
    this.items = page.getContent();

    return this;
  }

  @Getter
  private boolean loadAll;
  @Getter
  private int pageIndex;
  @Getter
  private int pageSize;
  @Getter
  private Map<String, Object> mapBean;
  @Getter
  private Map<String, String> orderBy;
  
  @Getter
  @Setter
  private int pageCount;
  @Getter
  @Setter
  private long recordCount;
  
  @Getter
  @Setter
  private int currentItemCount;
  
  @Getter
  @Setter
  private List<Biz> items;
  
}
