package com.supwisdom.institute.backend.admin.bff.api.v1.model.base;

import java.util.Collection;

import com.supwisdom.institute.backend.common.framework.model.ABaseModel;

import lombok.Getter;
import lombok.Setter;

public class ResourceRoleSet extends ABaseModel {

  /**
   * 
   */
  private static final long serialVersionUID = -683204173918706673L;

  public static final String ACCESS_ANONYMOUS = "anonymous"; // 匿名访问anonymous
  public static final String ACCESS_AUTHENTICATE = "authenticate"; // 认证访问authenticate
  public static final String ACCESS_AUTHORIZE = "authorize"; // 授权访问authorize
  public static final String ACCESS_PERMIT_ALL = "permitAll"; // 允许所有permitAll
  public static final String ACCESS_DENY_ALL = "denyAll"; // 拒绝所有denyAll

  @Getter
  @Setter
  private String id;

  /**
   * 代码
   */
  @Getter
  @Setter
  private String code;

  /**
   * 名称
   */
  @Getter
  @Setter
  private String name;

  /**
   * 备注
   */
  @Getter
  @Setter
  private String memo;

  /**
   * 状态（1 启用，0 停用）
   */
  @Getter
  @Setter
  private String status;

  /**
   * 请求方式（GET、POST、PUT、DELETE 等）
   */
  @Getter
  @Setter
  private String method;

  /**
   * 请求路径
   */
  @Getter
  @Setter
  private String path;

  /**
   * 访问规则（匿名访问anonymous、认证访问authenticate、授权访问authorize、允许所有permitAll、拒绝所有denyAll）
   */
  @Getter
  @Setter
  private String access;

  @Getter
  @Setter
  Collection<Role> roles;
  
}
