package com.supwisdom.institute.backend.gateway.security.core.userdetails;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.springframework.security.core.GrantedAuthority;

import com.supwisdom.infras.security.core.userdetails.InfrasUser;

public class MyUser extends InfrasUser {

  /**
   * 
   */
  private static final long serialVersionUID = 3195151947212484499L;

  public MyUser(String username, String password, 
      Collection<? extends GrantedAuthority> authorities, 
      Map<String, Object> attributes) {
    this(username, password, true, true, true, true, authorities, attributes);
  }

  public MyUser(String username, String password, 
      boolean enabled, boolean accountNonExpired, boolean credentialsNonExpired, boolean accountNonLocked, 
      Collection<? extends GrantedAuthority> authorities, 
      Map<String, Object> attributes) {
    super(username, password, enabled, accountNonExpired, credentialsNonExpired, accountNonLocked, authorities, attributes);
    
    this.attributes = attributes;
  }

  private final Map<String, Object> attributes;
  public Map<String, Object> getAttributes() {
    return this.attributes;
  }
  
  public List<String> getRoles() {
    List<String> roles = new ArrayList<>();
    for (GrantedAuthority grantedAuthority : this.getAuthorities()) {
      roles.add(grantedAuthority.getAuthority());
    }
    
    return roles;
  }
  

  public Object getAttribute(String key) {
    if (attributes == null) {
      return null;
    }
    
    if (!attributes.containsKey(key)) {
      return null;
    }
    
    return attributes.get(key);
  }
  
}
