package com.supwisdom.institute.backend.base.domain.repo;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Repository;

import com.supwisdom.institute.backend.base.domain.entity.Group;
import com.supwisdom.institute.backend.base.domain.entity.GroupRole;
import com.supwisdom.institute.backend.base.domain.entity.Role;
import com.supwisdom.institute.backend.common.framework.repo.BaseJpaRepository;
import com.supwisdom.institute.backend.common.util.MapBeanUtils;

@Repository
public interface GroupRoleRepository extends BaseJpaRepository<GroupRole> {

  public default Page<GroupRole> selectPageList(int pageIndex, int pageSize, Map<String, Object> mapBean) {
    GroupRole probe = new GroupRole();
    if (mapBean != null) {
      probe.setGroupId(MapBeanUtils.getString(mapBean, "groupId"));
      probe.setRoleId(MapBeanUtils.getString(mapBean, "roleId"));
    }

    ExampleMatcher matcher = ExampleMatcher.matching()
        .withMatcher("groupId", ExampleMatcher.GenericPropertyMatchers.exact())
        .withMatcher("roleId", ExampleMatcher.GenericPropertyMatchers.exact());

    PageRequest pageRequest = PageRequest.of(pageIndex, pageSize);
    Example<GroupRole> example = Example.of(probe, matcher);

    Page<GroupRole> page = this.findAll(example, pageRequest);

    return page;
  }

  public default Page<GroupRole> selectGroupRoles(int pageIndex, int pageSize, Map<String, Object> mapBean) {

    GroupRole probe = new GroupRole();
    if (mapBean != null) {
      probe.setGroupId(MapBeanUtils.getString(mapBean, "groupId"));
      probe.setRoleId(MapBeanUtils.getString(mapBean, "roleId"));
    }

    ExampleMatcher matcher = ExampleMatcher.matching()
        .withMatcher("groupId", ExampleMatcher.GenericPropertyMatchers.exact())
        .withMatcher("roleId", ExampleMatcher.GenericPropertyMatchers.exact());

    Example<GroupRole> example = Example.of(probe, matcher);

    PageRequest pageRequest = PageRequest.of(pageIndex, pageSize);

    Page<GroupRole> page = this.findAll(example, pageRequest);  // FIXME: 多表关联查询

    return page;
  }

  public default void relateGroupRoles(Group group, List<GroupRole> groupRoles) {

    List<GroupRole> existGroupRoles = this.selectListByGroupId(group.getId());

    Map<String, GroupRole> existMapGroupRoles = new LinkedHashMap<String, GroupRole>();
    for (GroupRole groupRole : existGroupRoles) {
      String k = String.format("%s", groupRole.getRoleId());
      existMapGroupRoles.put(k, groupRole);
    }

    for (GroupRole groupRole : groupRoles) {
      String k = String.format("%s", groupRole.getRoleId());

      if (existMapGroupRoles.containsKey(k)) {
        existMapGroupRoles.remove(k);
      } else {
        groupRole.setCompanyId(group.getCompanyId());
        groupRole.setGroupId(group.getId());

        this.insert(groupRole);
      }
    }

    for (GroupRole groupRole : existMapGroupRoles.values()) {
      this.deleteById(groupRole.getId());
    }
  }

  public default List<GroupRole> selectListByGroupId(String groupId) {

    GroupRole probe = new GroupRole();
    probe.setGroupId(groupId);

    ExampleMatcher matcher = ExampleMatcher.matching().withMatcher("groupId",
        ExampleMatcher.GenericPropertyMatchers.exact());

    Example<GroupRole> example = Example.of(probe, matcher);

    List<GroupRole> groupRoles = this.findAll(example);

    return groupRoles;
  }


  public default void relateRoleGroups(Role role, List<GroupRole> groupRoles) {

    List<GroupRole> existRoleGroups = this.selectListByRoleId(role.getCode());

    Map<String, GroupRole> existMapRoleGroups = new LinkedHashMap<String, GroupRole>();
    for (GroupRole groupRole : existRoleGroups) {
      String k = String.format("%s", groupRole.getGroupId());
      existMapRoleGroups.put(k, groupRole);
    }

    for (GroupRole groupRole : groupRoles) {
      String k = String.format("%s", groupRole.getGroupId());

      if (existMapRoleGroups.containsKey(k)) {
        existMapRoleGroups.remove(k);
      } else {
        groupRole.setCompanyId(role.getCompanyId());
        groupRole.setRoleId(role.getId());

        this.insert(groupRole);
      }
    }

    for (GroupRole groupRole : existMapRoleGroups.values()) {
      this.deleteById(groupRole.getId());
    }
  }

  public default List<GroupRole> selectListByRoleId(String roleId) {

    GroupRole probe = new GroupRole();
    probe.setRoleId(roleId);

    ExampleMatcher matcher = ExampleMatcher.matching()
        .withMatcher("roleId", ExampleMatcher.GenericPropertyMatchers.exact());

    Example<GroupRole> example = Example.of(probe, matcher);

    List<GroupRole> groupRoles = this.findAll(example);

    return groupRoles;
  }

  public default GroupRole selectOneByGroupRole(String groupId, String roleId) {

    GroupRole probe = new GroupRole();
    probe.setGroupId(groupId);
    probe.setRoleId(roleId);

    ExampleMatcher matcher = ExampleMatcher.matching()
        .withMatcher("groupId", ExampleMatcher.GenericPropertyMatchers.exact())
        .withMatcher("roleId", ExampleMatcher.GenericPropertyMatchers.exact())
        ;

    Example<GroupRole> example = Example.of(probe, matcher);
    
    Optional<GroupRole> o = this.findOne(example);
    
    return o.isPresent() ? o.get() : null;
  }

  public default void addGroupRole(String groupId, String roleId) {

    GroupRole groupRole = this.selectOneByGroupRole(groupId, roleId);
    
    if (groupRole == null) {
      groupRole = new GroupRole();
      //groupRole.setCompanyId(companyId);
      groupRole.setGroupId(groupId);
      groupRole.setRoleId(roleId);
      
      this.insert(groupRole);
    }
  }

  public default void removeGroupRole(String groupId, String roleId) {

    GroupRole groupRole = this.selectOneByGroupRole(groupId, roleId);
    
    if (groupRole != null) {
      this.deleteById(groupRole.getId());
    }
  }

}
