package com.supwisdom.institute.backend.base.domain.repo;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;

import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

import com.supwisdom.institute.backend.base.domain.entity.Resource;
import com.supwisdom.institute.backend.common.framework.repo.BaseJpaRepository;
import com.supwisdom.institute.backend.common.util.MapBeanUtils;

@Repository
public interface ResourceRepository extends BaseJpaRepository<Resource> {

  @Override
  public default Specification<Resource> convertToSpec(Map<String, Object> mapBean) {
    
    Specification<Resource> spec = new Specification<Resource>() {

      /**
       * 
       */
      private static final long serialVersionUID = 7690039558726467041L;

      @Override
      public Predicate toPredicate(Root<Resource> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
        List<Predicate> predicates = new ArrayList<>();
        
        if (mapBean != null) {

          if (MapBeanUtils.getBoolean(mapBean, "deleted") != null) {
            predicates.add(criteriaBuilder.equal(root.get("deleted"), MapBeanUtils.getBoolean(mapBean, "deleted")));
          }

          if (!StringUtils.isEmpty(MapBeanUtils.getString(mapBean, "code"))) {
            predicates.add(criteriaBuilder.like(root.get("code"), "%" + MapBeanUtils.getString(mapBean, "code") + "%"));
          }
          if (!StringUtils.isEmpty(MapBeanUtils.getString(mapBean, "name"))) {
            predicates.add(criteriaBuilder.like(root.get("name"), "%" + MapBeanUtils.getString(mapBean, "name") + "%"));
          }
          if (!StringUtils.isEmpty(MapBeanUtils.getString(mapBean, "memo"))) {
            predicates.add(criteriaBuilder.like(root.get("memo"), "%" + MapBeanUtils.getString(mapBean, "memo") + "%"));
          }
          
          if (!StringUtils.isEmpty(MapBeanUtils.getString(mapBean, "status"))) {
            predicates.add(criteriaBuilder.equal(root.get("status"), MapBeanUtils.getString(mapBean, "status")));
          }
          
          List<Predicate> predicatesKeyword = new ArrayList<>();
          if (!StringUtils.isEmpty(MapBeanUtils.getString(mapBean, "keyword"))) {
            predicatesKeyword.add(criteriaBuilder.like(root.get("code"), "%" + MapBeanUtils.getString(mapBean, "keyword") + "%"));
            predicatesKeyword.add(criteriaBuilder.like(root.get("name"), "%" + MapBeanUtils.getString(mapBean, "keyword") + "%"));
            predicatesKeyword.add(criteriaBuilder.like(root.get("memo"), "%" + MapBeanUtils.getString(mapBean, "keyword") + "%"));
            
            predicates.add(criteriaBuilder.or(predicatesKeyword.toArray(new Predicate[predicatesKeyword.size()])));
          }
        }
        
        return criteriaBuilder.and(predicates.toArray(new Predicate[predicates.size()]));
      }
      
    };
    
    return spec;
  }
  
//  @Override
//  public default Page<Resource> selectPageList(boolean loadAll, int pageIndex, int pageSize, Map<String, Object> mapBean, Map<String, String> orderBy) {
//    if (loadAll) {
//      pageIndex = 0;
//      pageSize = Integer.MAX_VALUE;
//    }
//    
//    Resource probe = new Resource();
//    if (mapBean != null) {
//      probe.setDeleted(MapBeanUtils.getBoolean(mapBean, "deleted"));
//      probe.setCode(MapBeanUtils.getString(mapBean, "code"));
//      probe.setName(MapBeanUtils.getString(mapBean, "name"));
//      probe.setMemo(MapBeanUtils.getString(mapBean, "memo"));
//      probe.setStatus(MapBeanUtils.getString(mapBean, "status"));
//    }
//    
//    ExampleMatcher matcher = ExampleMatcher.matching()
//        .withMatcher("deleted", ExampleMatcher.GenericPropertyMatchers.exact())
//        .withMatcher("code", ExampleMatcher.GenericPropertyMatchers.contains())
//        .withMatcher("name", ExampleMatcher.GenericPropertyMatchers.contains())
//        .withMatcher("memo", ExampleMatcher.GenericPropertyMatchers.contains())
//        .withMatcher("status", ExampleMatcher.GenericPropertyMatchers.exact());
//    
//    PageRequest pageRequest = PageRequest.of(pageIndex, pageSize);
//    Example<Resource> example = Example.of(probe, matcher);
//    
//    Page<Resource> page = this.findAll(example, pageRequest);
//    
//    return page;
//  }

  public default Resource selectByCode(String code) {
    Resource probe = new Resource();
    probe.setCode(code);
    
    ExampleMatcher matcher = ExampleMatcher.matching()
        .withMatcher("code", ExampleMatcher.GenericPropertyMatchers.exact());
    
    Example<Resource> example = Example.of(probe, matcher);
    
    Optional<Resource> o = this.findOne(example);
    
    if (o.isPresent()) {
      return o.get();
    }
    
    return null;
  }
  
}
