/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnBase;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumnAccessor;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.rights.Grantee;
import org.hsqldb.types.Type;
import org.hsqldb.types.Types;

public final class ColumnSchema
extends ColumnBase
implements SchemaObject {
    public static final ColumnSchema[] emptyArray = new ColumnSchema[0];
    private HsqlNameManager.HsqlName columnName;
    private boolean isPrimaryKey;
    private Expression defaultExpression;
    private Expression generatingExpression;
    private NumberSequence sequence;
    private OrderedHashSet references = new OrderedHashSet();
    private OrderedHashSet generatedColumnReferences;
    private Expression accessor;

    public ColumnSchema(HsqlNameManager.HsqlName name, Type type, boolean isNullable, boolean isPrimaryKey, Expression defaultExpression) {
        this.columnName = name;
        this.nullability = isNullable ? (byte)1 : 0;
        this.dataType = type;
        this.isPrimaryKey = isPrimaryKey;
        this.defaultExpression = defaultExpression;
        this.setReferences();
    }

    public int getType() {
        return this.columnName.type;
    }

    public HsqlNameManager.HsqlName getName() {
        return this.columnName;
    }

    public String getNameString() {
        return this.columnName.name;
    }

    public String getTableNameString() {
        return this.columnName.parent == null ? null : this.columnName.parent.name;
    }

    public HsqlNameManager.HsqlName getSchemaName() {
        return this.columnName.schema;
    }

    public String getSchemaNameString() {
        return this.columnName.schema == null ? null : this.columnName.schema.name;
    }

    public HsqlNameManager.HsqlName getCatalogName() {
        return this.columnName.schema == null ? null : this.columnName.schema.schema;
    }

    public String getCatalogNameString() {
        return this.columnName.schema == null ? null : (this.columnName.schema.schema == null ? null : this.columnName.schema.schema.name);
    }

    public Grantee getOwner() {
        return this.columnName.schema == null ? null : this.columnName.schema.owner;
    }

    public OrderedHashSet getReferences() {
        return this.references;
    }

    public OrderedHashSet getComponents() {
        return null;
    }

    public void compile(Session session, SchemaObject table) {
        if (this.generatingExpression == null) {
            return;
        }
        this.generatingExpression.resetColumnReferences();
        this.generatingExpression.resolveCheckOrGenExpression(session, ((Table)table).defaultRanges, false);
        if (this.dataType.typeComparisonGroup != this.generatingExpression.getDataType().typeComparisonGroup) {
            throw Error.error(5561);
        }
        this.setReferences();
    }

    public String getSQL() {
        StringBuffer sb = new StringBuffer();
        switch (this.parameterMode) {
            case 1: {
                sb.append("IN").append(' ');
                break;
            }
            case 4: {
                sb.append("OUT").append(' ');
                break;
            }
            case 2: {
                sb.append("INOUT").append(' ');
            }
        }
        if (this.columnName != null) {
            sb.append(this.columnName.statementName);
            sb.append(' ');
        }
        sb.append(this.dataType.getTypeDefinition());
        if (this.dataType.hasCollation()) {
            sb.append(' ').append("COLLATE").append(' ');
            sb.append(this.dataType.getCollationDefinition());
        }
        return sb.toString();
    }

    public long getChangeTimestamp() {
        return 0L;
    }

    public void setType(Type type) {
        this.dataType = type;
        this.setReferences();
    }

    public void setName(HsqlNameManager.HsqlName name) {
        this.columnName = name;
    }

    void setIdentity(NumberSequence sequence) {
        this.sequence = sequence;
        this.isIdentity = sequence != null;
    }

    void setType(ColumnSchema other) {
        this.nullability = other.nullability;
        this.dataType = other.dataType;
    }

    public NumberSequence getIdentitySequence() {
        return this.sequence;
    }

    public boolean isNullable() {
        boolean isNullable = super.isNullable();
        if (isNullable && this.dataType.isDomainType()) {
            return this.dataType.userTypeModifier.isNullable();
        }
        return isNullable;
    }

    public byte getNullability() {
        return this.isPrimaryKey ? (byte)0 : super.getNullability();
    }

    public boolean isGenerated() {
        return this.generatingExpression != null;
    }

    public boolean hasDefault() {
        return this.getDefaultExpression() != null;
    }

    public boolean isWriteable() {
        return !this.isGenerated();
    }

    public void setWriteable(boolean value) {
        throw Error.runtimeError(201, "ColumnSchema");
    }

    public boolean isSearchable() {
        return Types.isSearchable(this.dataType.typeCode);
    }

    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    void setPrimaryKey(boolean value) {
        this.isPrimaryKey = value;
    }

    public Object getDefaultValue(Session session) {
        return this.defaultExpression == null ? null : this.defaultExpression.getValue(session, this.dataType);
    }

    public Object getGeneratedValue(Session session) {
        return this.generatingExpression == null ? null : this.generatingExpression.getValue(session, this.dataType);
    }

    public String getDefaultSQL() {
        String ddl = null;
        ddl = this.defaultExpression == null ? null : this.defaultExpression.getSQL();
        return ddl;
    }

    Expression getDefaultExpression() {
        if (this.defaultExpression == null) {
            if (this.dataType.isDomainType()) {
                return this.dataType.userTypeModifier.getDefaultClause();
            }
            return null;
        }
        return this.defaultExpression;
    }

    void setDefaultExpression(Expression expr) {
        this.defaultExpression = expr;
    }

    public Expression getGeneratingExpression() {
        return this.generatingExpression;
    }

    void setGeneratingExpression(Expression expr) {
        this.generatingExpression = expr;
    }

    public ColumnSchema duplicate() {
        ColumnSchema copy = new ColumnSchema(this.columnName, this.dataType, true, this.isPrimaryKey, this.defaultExpression);
        copy.setNullability(this.nullability);
        copy.setGeneratingExpression(this.generatingExpression);
        copy.setIdentity(this.sequence);
        return copy;
    }

    public Expression getAccessor() {
        if (this.accessor == null) {
            this.accessor = new ExpressionColumnAccessor(this);
        }
        return this.accessor;
    }

    public OrderedHashSet getGeneratedColumnReferences() {
        return this.generatedColumnReferences;
    }

    private void setReferences() {
        this.references.clear();
        if (this.generatedColumnReferences != null) {
            this.generatedColumnReferences.clear();
        }
        if (this.dataType.isDomainType() || this.dataType.isDistinctType()) {
            HsqlNameManager.HsqlName name = this.dataType.getName();
            this.references.add(name);
        }
        if (this.generatingExpression != null) {
            this.generatingExpression.collectObjectNames(this.references);
            Iterator it = this.references.iterator();
            while (it.hasNext()) {
                HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)it.next();
                if (name.type != 9 && name.type != 3) continue;
                it.remove();
                if (this.generatedColumnReferences == null) {
                    this.generatedColumnReferences = new OrderedHashSet();
                }
                if (name.type != 9) continue;
                this.generatedColumnReferences.add(name);
            }
        }
    }
}

