/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Routine;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.rights.Grantee;
import org.hsqldb.types.Type;

public class RoutineSchema
implements SchemaObject {
    Routine[] routines = Routine.emptyArray;
    int routineType;
    private HsqlNameManager.HsqlName name;

    public RoutineSchema(int type, HsqlNameManager.HsqlName name) {
        this.routineType = type;
        this.name = name;
    }

    public int getType() {
        return this.routineType;
    }

    public HsqlNameManager.HsqlName getCatalogName() {
        return this.name.schema.schema;
    }

    public HsqlNameManager.HsqlName getSchemaName() {
        return this.name.schema;
    }

    public HsqlNameManager.HsqlName getName() {
        return this.name;
    }

    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    public OrderedHashSet getReferences() {
        OrderedHashSet set = new OrderedHashSet();
        for (int i = 0; i < this.routines.length; ++i) {
            set.addAll(this.routines[i].getReferences());
        }
        return set;
    }

    public OrderedHashSet getComponents() {
        OrderedHashSet set = new OrderedHashSet();
        set.addAll(this.routines);
        return set;
    }

    public void compile(Session session, SchemaObject parentObject) {
    }

    public String getSQL() {
        return null;
    }

    public long getChangeTimestamp() {
        return 0L;
    }

    public String[] getSQLArray() {
        HsqlArrayList list = new HsqlArrayList();
        for (int i = 0; i < this.routines.length; ++i) {
            list.add(this.routines[i].getSQL());
        }
        String[] array = new String[list.size()];
        list.toArray(array);
        return array;
    }

    public void addSpecificRoutine(Database database, Routine routine) {
        int signature = routine.getParameterSignature();
        Type[] types = routine.getParameterTypes();
        for (int i = 0; i < this.routines.length; ++i) {
            if (this.routines[i].parameterTypes.length != types.length) continue;
            if (this.routineType == 17) {
                throw Error.error(5605);
            }
            if (this.routines[i].isAggregate() != routine.isAggregate()) {
                throw Error.error(5605);
            }
            boolean match = true;
            for (int j = 0; j < types.length; ++j) {
                if (this.routines[i].parameterTypes[j].equals(types[j])) continue;
                match = false;
                break;
            }
            if (!match) continue;
            throw Error.error(5605);
        }
        if (routine.getSpecificName() == null) {
            HsqlNameManager.HsqlName specificName = database.nameManager.newSpecificRoutineName(this.name);
            routine.setSpecificName(specificName);
        } else {
            routine.getSpecificName().parent = this.name;
            routine.getSpecificName().schema = this.name.schema;
        }
        routine.setName(this.name);
        routine.routineSchema = this;
        this.routines = (Routine[])ArrayUtil.resizeArray(this.routines, this.routines.length + 1);
        this.routines[this.routines.length - 1] = routine;
    }

    public void removeSpecificRoutine(Routine routine) {
        for (int i = 0; i < this.routines.length; ++i) {
            if (this.routines[i] != routine) continue;
            this.routines = (Routine[])ArrayUtil.toAdjustedArray(this.routines, null, i, -1);
            break;
        }
    }

    public Routine[] getSpecificRoutines() {
        return this.routines;
    }

    public Routine getSpecificRoutine(Type[] types) {
        int matchIndex = -1;
        block0: for (int i = 0; i < this.routines.length; ++i) {
            int j;
            int newDiff;
            int oldDiff;
            int matchCount = 0;
            if (this.routines[i].isAggregate() && types.length == 1) {
                if (types[0] == null) {
                    return this.routines[i];
                }
                int typeDifference = types[0].precedenceDegree(this.routines[i].parameterTypes[0]);
                if (typeDifference < -128) {
                    if (matchIndex == -1 || (oldDiff = types[0].precedenceDegree(this.routines[matchIndex].parameterTypes[0])) == (newDiff = types[0].precedenceDegree(this.routines[i].parameterTypes[0])) || newDiff >= oldDiff) continue;
                    matchIndex = i;
                    continue;
                }
                if (typeDifference == 0) {
                    return this.routines[i];
                }
                matchIndex = i;
                continue;
            }
            if (this.routines[i].parameterTypes.length != types.length) continue;
            if (types.length == 0) {
                return this.routines[i];
            }
            for (j = 0; j < types.length; ++j) {
                if (types[j] == null) continue;
                int typeDifference = types[j].precedenceDegree(this.routines[i].parameterTypes[j]);
                if (typeDifference < -128) continue block0;
                if (typeDifference != 0 || matchCount != j) continue;
                matchCount = j + 1;
            }
            if (matchCount == types.length) {
                return this.routines[i];
            }
            if (matchIndex == -1) {
                matchIndex = i;
                continue;
            }
            for (j = 0; j < types.length; ++j) {
                if (types[j] == null || (oldDiff = types[j].precedenceDegree(this.routines[matchIndex].parameterTypes[j])) == (newDiff = types[j].precedenceDegree(this.routines[i].parameterTypes[j]))) continue;
                if (newDiff >= oldDiff) continue block0;
                matchIndex = i;
                continue block0;
            }
        }
        if (matchIndex < 0) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.name.getSchemaQualifiedStatementName());
            sb.append("(");
            for (int i = 0; i < types.length; ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(types[i].getNameString());
            }
            sb.append(")");
            throw Error.error(5609, sb.toString());
        }
        return this.routines[matchIndex];
    }

    public Routine getSpecificRoutine(int paramCount) {
        for (int i = 0; i < this.routines.length; ++i) {
            if (this.routines[i].parameterTypes.length != paramCount) continue;
            return this.routines[i];
        }
        throw Error.error(5501);
    }

    public boolean isAggregate() {
        return this.routines[0].isAggregate;
    }
}

