/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import org.hsqldb.RowAVL;
import org.hsqldb.TableBase;
import org.hsqldb.error.Error;
import org.hsqldb.index.NodeAVL;
import org.hsqldb.index.NodeAVLDisk;
import org.hsqldb.lib.IntLookup;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

public class RowAVLDisk
extends RowAVL {
    public static final int NO_POS = -1;
    int storageSize;
    int keepCount;
    boolean isInMemory;
    int accessCount;
    private boolean hasDataChanged;
    private boolean hasNodesChanged;

    public RowAVLDisk(TableBase t, Object[] o, PersistentStore store) {
        super(t, o);
        this.setNewNodes(store);
        this.hasNodesChanged = true;
        this.hasDataChanged = true;
    }

    public RowAVLDisk(TableBase t, RowInputInterface in) throws IOException {
        super(t, null);
        this.position = in.getPos();
        this.storageSize = in.getSize();
        int indexcount = t.getIndexCount();
        NodeAVL n = this.nPrimaryNode = new NodeAVLDisk(this, in, 0);
        for (int i = 1; i < indexcount; ++i) {
            n = n.nNext = new NodeAVLDisk(this, in, i);
        }
        this.rowData = in.readData(this.table.getColumnTypes());
    }

    public NodeAVL insertNode(int index) {
        return null;
    }

    private void readRowInfo(RowInputInterface in) throws IOException {
    }

    public synchronized void setNodesChanged() {
        this.hasNodesChanged = true;
    }

    public void updateAccessCount(int count) {
        this.accessCount = count;
    }

    public int getAccessCount() {
        return this.accessCount;
    }

    public int getStorageSize() {
        return this.storageSize;
    }

    public boolean isMemory() {
        return false;
    }

    public void setPos(int pos) {
        this.position = pos;
        NodeAVL n = this.nPrimaryNode;
        while (n != null) {
            ((NodeAVLDisk)n).iData = this.position;
            n = n.nNext;
        }
    }

    public synchronized void setChanged(boolean changed) {
        this.hasDataChanged = changed;
    }

    public synchronized boolean hasChanged() {
        return this.hasNodesChanged || this.hasDataChanged;
    }

    public TableBase getTable() {
        return this.table;
    }

    public void setStorageSize(int size) {
        this.storageSize = size;
    }

    public synchronized boolean isKeepInMemory() {
        return this.keepCount > 0;
    }

    public void delete(PersistentStore store) {
        RowAVLDisk row = this;
        if (!row.keepInMemory(true)) {
            row = (RowAVLDisk)store.get(row, true);
        }
        super.delete(store);
        row.keepInMemory(false);
    }

    public void destroy() {
        this.nPrimaryNode = null;
        this.table = null;
    }

    public synchronized boolean keepInMemory(boolean keep) {
        if (!this.isInMemory) {
            return false;
        }
        if (keep) {
            ++this.keepCount;
        } else {
            --this.keepCount;
            if (this.keepCount < 0) {
                throw Error.runtimeError(201, "RowAVLDisk - keep count");
            }
        }
        return true;
    }

    public synchronized boolean isInMemory() {
        return this.isInMemory;
    }

    public synchronized void setInMemory(boolean in) {
        this.isInMemory = in;
        if (in) {
            return;
        }
        NodeAVL n = this.nPrimaryNode;
        while (n != null) {
            n.setInMemory(in);
            n = n.nNext;
        }
    }

    public void setNewNodes(PersistentStore store) {
        int indexcount = store.getAccessorKeys().length;
        NodeAVL n = this.nPrimaryNode = new NodeAVLDisk(this, 0);
        for (int i = 1; i < indexcount; ++i) {
            n = n.nNext = new NodeAVLDisk(this, i);
        }
    }

    public int getRealSize(RowOutputInterface out) {
        return out.getSize(this);
    }

    public void write(RowOutputInterface out) {
        try {
            this.writeNodes(out);
            if (this.hasDataChanged) {
                out.writeData(this, this.table.colTypes);
                out.writeEnd();
                this.hasDataChanged = false;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void write(RowOutputInterface out, IntLookup lookup) {
        out.writeSize(this.storageSize);
        NodeAVL rownode = this.nPrimaryNode;
        while (rownode != null) {
            ((NodeAVLDisk)rownode).write(out, lookup);
            rownode = rownode.nNext;
        }
        out.writeData(this, this.table.colTypes);
        out.writeEnd();
    }

    private void writeNodes(RowOutputInterface out) throws IOException {
        out.writeSize(this.storageSize);
        NodeAVL n = this.nPrimaryNode;
        while (n != null) {
            n.write(out);
            n = n.nNext;
        }
        this.hasNodesChanged = false;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof RowAVLDisk) {
            return ((RowAVLDisk)obj).position == this.position;
        }
        return false;
    }

    public int hashCode() {
        return this.position;
    }
}

