/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Row;
import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.Table;
import org.hsqldb.TransactionManager;
import org.hsqldb.TransactionManagerCommon;
import org.hsqldb.lib.DoubleIntIndex;
import org.hsqldb.lib.HsqlDeque;
import org.hsqldb.lib.IntKeyHashMapConcurrent;
import org.hsqldb.lib.LongDeque;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.PersistentStore;

public class TransactionManagerMV2PL
extends TransactionManagerCommon
implements TransactionManager {
    HsqlDeque committedTransactions = new HsqlDeque();
    LongDeque committedTransactionTimestamps = new LongDeque();

    public TransactionManagerMV2PL(Database db) {
        this.database = db;
        this.lobSession = this.database.sessionManager.getSysLobSession();
        this.rowActionMap = new IntKeyHashMapConcurrent(10000);
        this.txModel = 1;
        this.catalogNameList = new HsqlNameManager.HsqlName[]{this.database.getCatalogName()};
    }

    public long getGlobalChangeTimestamp() {
        return this.globalChangeTimestamp.get();
    }

    public boolean isMVRows() {
        return true;
    }

    public boolean isMVCC() {
        return false;
    }

    public int getTransactionControl() {
        return 1;
    }

    public void setTransactionControl(Session session, int mode) {
        super.setTransactionControl(session, mode);
    }

    public void completeActions(Session session) {
        this.endActionTPL(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean prepareCommitActions(Session session) {
        Object[] list = session.rowActionList.getArray();
        int limit = session.rowActionList.size();
        this.writeLock.lock();
        try {
            session.actionTimestamp = this.nextChangeTimestamp();
            for (int i = 0; i < limit; ++i) {
                RowAction action = (RowAction)list[i];
                action.prepareCommit(session);
            }
            boolean bl = true;
            Object var7_6 = null;
            this.writeLock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean commitTransaction(Session session) {
        if (session.abortTransaction) {
            return false;
        }
        int limit = session.rowActionList.size();
        Object[] list = session.rowActionList.getArray();
        this.writeLock.lock();
        try {
            session.transactionEndTimestamp = session.actionTimestamp = this.nextChangeTimestamp();
            this.endTransaction(session);
            for (int i = 0; i < limit; ++i) {
                RowAction action = (RowAction)list[i];
                action.commit(session);
            }
            this.persistCommit(session, list, limit);
            int newLimit = session.rowActionList.size();
            if (newLimit > limit) {
                list = session.rowActionList.getArray();
                this.mergeTransaction(session, list, limit, newLimit, session.actionTimestamp);
                this.finaliseRows(session, list, limit, newLimit, true);
                session.rowActionList.setSize(limit);
            }
            if (this.getFirstLiveTransactionTimestamp() > session.actionTimestamp || session == this.lobSession) {
                this.mergeTransaction(session, list, 0, limit, session.actionTimestamp);
                this.finaliseRows(session, list, 0, limit, true);
            } else {
                list = session.rowActionList.toArray();
                this.addToCommittedQueue(session, list);
            }
            this.endTransactionTPL(session);
            Object var7_6 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.writeLock.unlock();
            throw throwable;
        }
        session.tempSet.clear();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Session session) {
        this.writeLock.lock();
        try {
            session.abortTransaction = false;
            session.transactionEndTimestamp = session.actionTimestamp = this.nextChangeTimestamp();
            this.rollbackPartial(session, 0, session.transactionTimestamp);
            this.endTransaction(session);
            this.endTransactionTPL(session);
            Object var3_2 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    public void rollbackSavepoint(Session session, int index) {
        long timestamp = session.sessionContext.savepointTimestamps.get(index);
        Integer oi = (Integer)session.sessionContext.savepoints.get(index);
        int start = oi;
        while (session.sessionContext.savepoints.size() > index + 1) {
            session.sessionContext.savepoints.remove(session.sessionContext.savepoints.size() - 1);
            session.sessionContext.savepointTimestamps.removeLast();
        }
        this.rollbackPartial(session, start, timestamp);
    }

    public void rollbackAction(Session session) {
        this.rollbackPartial(session, session.actionIndex, session.actionTimestamp);
        this.endActionTPL(session);
    }

    void rollbackPartial(Session session, int start, long timestamp) {
        Object[] list = session.rowActionList.getArray();
        int limit = session.rowActionList.size();
        if (start == limit) {
            return;
        }
        for (int i = start; i < limit; ++i) {
            RowAction action = (RowAction)list[i];
            if (action != null) {
                action.rollback(session, timestamp);
                continue;
            }
            System.out.println("null action in rollback " + start);
        }
        this.mergeRolledBackTransaction(session, timestamp, list, start, limit);
        this.finaliseRows(session, list, start, limit, false);
        session.rowActionList.setSize(start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowAction addDeleteAction(Session session, Table table, Row row, int[] colMap) {
        RowAction action;
        boolean newAction;
        Row row2 = row;
        synchronized (row2) {
            newAction = row.rowAction == null;
            action = RowAction.addDeleteAction(session, table, row, colMap);
        }
        session.rowActionList.add(action);
        if (newAction && table.tableType == 5) {
            this.rowActionMap.put(action.getPos(), action);
        }
        return action;
    }

    public void addInsertAction(Session session, Table table, PersistentStore store, Row row, int[] changedColumns) {
        RowAction action = row.rowAction;
        if (action == null) {
            System.out.println("null insert action " + session + " " + session.actionTimestamp);
        }
        if (table.tableType == 5) {
            this.rowActionMap.put(action.getPos(), action);
        }
        store.indexRow(session, row);
        session.rowActionList.add(action);
    }

    public boolean canRead(Session session, Row row, int mode, int[] colMap) {
        RowAction action = row.rowAction;
        if (action == null) {
            return true;
        }
        return action.canRead(session, 0);
    }

    public boolean canRead(Session session, int id, int mode) {
        RowAction action = (RowAction)this.rowActionMap.get(id);
        return action == null ? true : action.canRead(session, 0);
    }

    public void setTransactionInfo(CachedObject object) {
        RowAction rowact;
        if (object.isMemory()) {
            return;
        }
        Row row = (Row)object;
        row.rowAction = rowact = (RowAction)this.rowActionMap.get(row.position);
    }

    public void removeTransactionInfo(CachedObject object) {
        if (object.isMemory()) {
            return;
        }
        this.rowActionMap.remove(object.getPos());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToCommittedQueue(Session session, Object[] list) {
        LongDeque longDeque = this.committedTransactionTimestamps;
        synchronized (longDeque) {
            this.committedTransactions.addLast(list);
            this.committedTransactionTimestamps.addLast(session.actionTimestamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeExpiredTransactions(Session session) {
        long timestamp = this.getFirstLiveTransactionTimestamp();
        while (true) {
            long commitTimestamp = 0L;
            Object[] actions = null;
            LongDeque longDeque = this.committedTransactionTimestamps;
            synchronized (longDeque) {
                if (this.committedTransactionTimestamps.isEmpty()) {
                    break;
                }
                commitTimestamp = this.committedTransactionTimestamps.getFirst();
                if (commitTimestamp >= timestamp) {
                    break;
                }
                this.committedTransactionTimestamps.removeFirst();
                actions = (Object[])this.committedTransactions.removeFirst();
            }
            this.mergeTransaction(session, actions, 0, actions.length, commitTimestamp);
            this.finaliseRows(session, actions, 0, actions.length, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginTransaction(Session session) {
        this.writeLock.lock();
        try {
            if (!session.isTransaction) {
                session.transactionTimestamp = session.actionTimestamp = this.nextChangeTimestamp();
                session.isTransaction = true;
                ++this.transactionCount;
                this.liveTransactionTimestamps.addLast(session.transactionTimestamp);
            }
            Object var3_2 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginAction(Session session, Statement cs) {
        if (session.hasLocks(cs)) {
            return;
        }
        this.writeLock.lock();
        try {
            boolean canProceed;
            if (cs.getCompileTimestamp() < this.database.schemaManager.getSchemaChangeTimestamp()) {
                session.sessionContext.currentStatement = cs = session.statementManager.getStatement(session, cs);
                if (cs == null) {
                    Object var5_3 = null;
                    this.writeLock.unlock();
                    return;
                }
            }
            if (canProceed = this.setWaitedSessionsTPL(session, cs)) {
                if (session.tempSet.isEmpty()) {
                    this.lockTablesTPL(session, cs);
                } else {
                    this.setWaitingSessionTPL(session);
                }
            } else {
                session.abortTransaction = true;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.writeLock.unlock();
            throw throwable;
        }
        Object var5_4 = null;
        this.writeLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginActionResume(Session session) {
        this.writeLock.lock();
        try {
            session.actionTimestamp = this.nextChangeTimestamp();
            if (!session.isTransaction) {
                session.transactionTimestamp = session.actionTimestamp;
                session.isTransaction = true;
                this.liveTransactionTimestamps.addLast(session.actionTimestamp);
                ++this.transactionCount;
            }
            Object var3_2 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    void endTransaction(Session session) {
        long timestamp = session.transactionTimestamp;
        session.isTransaction = false;
        int index = this.liveTransactionTimestamps.indexOf(timestamp);
        if (index >= 0) {
            --this.transactionCount;
            this.liveTransactionTimestamps.remove(index);
            this.mergeExpiredTransactions(session);
        }
    }

    public DoubleIntIndex getTransactionIDList() {
        return super.getTransactionIDList();
    }

    public void convertTransactionIDs(DoubleIntIndex lookup) {
        super.convertTransactionIDs(lookup);
    }
}

