/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.auth;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Set;
import org.hsqldb.auth.AuthFunctionBean;
import org.hsqldb.auth.AuthUtils;
import org.hsqldb.auth.DenyException;
import org.hsqldb.lib.FrameworkLogger;

public class HsqldbSlaveAuthBean
implements AuthFunctionBean {
    private static FrameworkLogger logger = FrameworkLogger.getLog(HsqldbSlaveAuthBean.class);
    private String masterJdbcUrl;
    private String validationUser;
    private String validationPassword;
    private boolean delegateRolesSchema = true;
    protected boolean initialized;

    public void setValidationUser(String validationUser) {
        this.validationUser = validationUser;
    }

    public void setValidationPassword(String validationPassword) {
        this.validationPassword = validationPassword;
    }

    public void setMasterJdbcUrl(String masterJdbcUrl) {
        this.masterJdbcUrl = masterJdbcUrl;
    }

    public void setDelegateRolesSchema(boolean doDelegateRolesSchema) {
        this.delegateRolesSchema = doDelegateRolesSchema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws SQLException {
        if (this.masterJdbcUrl == null) {
            throw new IllegalStateException("Required property 'masterJdbcUrl' not set");
        }
        if (this.validationUser != null || this.validationPassword != null) {
            if (this.validationUser == null || this.validationPassword == null) {
                throw new IllegalStateException("If you set one property of 'validationUser' or 'validationPassword', then you must set both.");
            }
            Connection c = null;
            SQLException problem = null;
            try {
                c = DriverManager.getConnection(this.masterJdbcUrl, this.validationUser, this.validationPassword);
            }
            catch (SQLException se) {
                logger.error("Master/slave Connection validation failure", se);
                problem = se;
            }
            finally {
                block16: {
                    if (c != null) {
                        try {
                            c.close();
                            c = null;
                        }
                        catch (SQLException nestedSe) {
                            logger.error("Failed to close test master/slave Connection", nestedSe);
                            if (problem != null) break block16;
                            throw nestedSe;
                        }
                    }
                }
            }
        }
        this.initialized = true;
    }

    public String[] authenticate(String userName, String password) throws DenyException {
        if (!this.initialized) {
            throw new IllegalStateException("You must invoke the 'init' method to initialize the " + HsqldbSlaveAuthBean.class.getName() + " instance.");
        }
        Connection c = null;
        try {
            c = DriverManager.getConnection(this.masterJdbcUrl, userName, password);
            if (this.delegateRolesSchema) {
                Set schemaAndRoles = AuthUtils.getEnabledRoles(c);
                String schemaOnMaster = AuthUtils.getInitialSchema(c);
                if (schemaOnMaster != null) {
                    schemaAndRoles.add(schemaOnMaster);
                }
                logger.finer("Slave delegating schema+roles: " + schemaAndRoles);
                String[] stringArray = schemaAndRoles.toArray(new String[0]);
                return stringArray;
            }
            String[] schemaAndRoles = null;
            return schemaAndRoles;
        }
        catch (SQLException se) {
            throw new DenyException();
        }
        finally {
            if (c != null) {
                try {
                    c.close();
                    c = null;
                }
                catch (SQLException nestedSe) {
                    logger.severe("Failed to close master/slave Connection", nestedSe);
                }
            }
        }
    }
}

