/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.index;

import org.hsqldb.Constraint;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Row;
import org.hsqldb.RowAVL;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.index.IndexAVL;
import org.hsqldb.index.NodeAVL;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.types.Type;

public class IndexAVLMemory
extends IndexAVL {
    public IndexAVLMemory(HsqlNameManager.HsqlName name, long id, TableBase table, int[] columns, boolean[] descending, boolean[] nullsLast, Type[] colTypes, boolean pk, boolean unique, boolean constraint, boolean forward) {
        super(name, id, table, columns, descending, nullsLast, colTypes, pk, unique, constraint, forward);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkIndex(PersistentStore store) {
        this.readLock.lock();
        try {
            NodeAVL p = this.getAccessor(store);
            NodeAVL f = null;
            while (p != null) {
                f = p;
                this.checkNodes(store, p);
                p = p.nLeft;
            }
            p = f;
            while (f != null) {
                this.checkNodes(store, f);
                f = this.next(store, f);
            }
            Object var5_4 = null;
            this.readLock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    void checkNodes(PersistentStore store, NodeAVL p) {
        NodeAVL l = p.nLeft;
        NodeAVL r = p.nRight;
        if (l != null && l.getBalance(store) == -2) {
            System.out.print("broken index - deleted");
        }
        if (r != null && r.getBalance(store) == -2) {
            System.out.print("broken index -deleted");
        }
        if (l != null && !p.equals(l.getParent(store))) {
            System.out.print("broken index - no parent");
        }
        if (r != null && !p.equals(r.getParent(store))) {
            System.out.print("broken index - no parent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(Session session, PersistentStore store, Row row) {
        boolean isleft = true;
        int compare = -1;
        Object[] rowData = row.getData();
        boolean compareRowId = !this.isUnique || this.hasNulls(session, rowData);
        boolean compareSimple = this.isSimple;
        this.writeLock.lock();
        try {
            NodeAVL n;
            NodeAVL x = n = this.getAccessor(store);
            if (n == null) {
                store.setAccessor((Index)this, ((RowAVL)row).getNode(this.position));
                Object var14_11 = null;
                this.writeLock.unlock();
                return;
            }
            do {
                Row currentRow = n.row;
                compare = 0;
                if (compareSimple) {
                    compare = this.colTypes[0].compare(session, rowData[this.colIndex[0]], currentRow.getData()[this.colIndex[0]]);
                    if (compare == 0 && compareRowId) {
                        compare = this.compareRowForInsertOrDelete(session, row, currentRow, compareRowId, 1);
                    }
                } else {
                    compare = this.compareRowForInsertOrDelete(session, row, currentRow, compareRowId, 0);
                }
                if (compare == 0 && session != null && !compareRowId && session.database.txManager.isMVRows() && !this.isEqualReadable(session, store, n)) {
                    compareRowId = true;
                    compare = this.compareRowForInsertOrDelete(session, row, currentRow, compareRowId, this.colIndex.length);
                }
                if (compare == 0) {
                    if (this.isConstraint) {
                        Constraint c = ((Table)this.table).getUniqueConstraintForIndex(this);
                        throw c.getException(row.getData());
                    }
                    throw Error.error(104, this.name.statementName);
                }
                isleft = compare < 0;
                x = n;
            } while ((n = isleft ? x.nLeft : x.nRight) != null);
            x = x.set(store, isleft, ((RowAVL)row).getNode(this.position));
            this.balance(store, x, isleft);
        }
        catch (Throwable throwable) {
            Object var14_13 = null;
            this.writeLock.unlock();
            throw throwable;
        }
        Object var14_12 = null;
        this.writeLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void delete(PersistentStore store, NodeAVL x) {
        block30: {
            block29: {
                if (x == null) {
                    return;
                }
                this.writeLock.lock();
                try {
                    NodeAVL n;
                    if (x.nLeft == null) {
                        n = x.nRight;
                    } else if (x.nRight == null) {
                        n = x.nLeft;
                    } else {
                        NodeAVL dl;
                        NodeAVL dp;
                        NodeAVL xp;
                        NodeAVL d;
                        block27: {
                            d = x;
                            x = x.nLeft;
                            while (true) {
                                NodeAVL temp;
                                if ((temp = x.nRight) == null) {
                                    n = x.nLeft;
                                    int b = x.iBalance;
                                    x.iBalance = d.iBalance;
                                    d.iBalance = b;
                                    xp = x.nParent;
                                    dp = d.nParent;
                                    if (d.isRoot(store)) {
                                        break;
                                    }
                                    break block27;
                                }
                                x = temp;
                            }
                            store.setAccessor((Index)this, x);
                        }
                        x.nParent = dp;
                        if (dp != null) {
                            if (dp.nRight == d) {
                                dp.nRight = x;
                            } else {
                                dp.nLeft = x;
                            }
                        }
                        if (d == xp) {
                            d.nParent = x;
                            if (d.nLeft == x) {
                                NodeAVL dr;
                                x.nLeft = d;
                                x.nRight = dr = d.nRight;
                            } else {
                                x.nRight = d;
                                x.nLeft = dl = d.nLeft;
                            }
                        } else {
                            d.nParent = xp;
                            xp.nRight = d;
                            dl = d.nLeft;
                            NodeAVL dr = d.nRight;
                            x.nLeft = dl;
                            x.nRight = dr;
                        }
                        x.nRight.nParent = x;
                        x.nLeft.nParent = x;
                        d.nLeft = n;
                        if (n != null) {
                            n.nParent = d;
                        }
                        d.nRight = null;
                        x = d;
                    }
                    boolean isleft = x.isFromLeft(store);
                    x.replace(store, this, n);
                    n = x.nParent;
                    x.delete();
                    while (n != null) {
                        x = n;
                        int sign = isleft ? 1 : -1;
                        switch (x.iBalance * sign) {
                            case -1: {
                                x.iBalance = 0;
                                break;
                            }
                            case 0: {
                                x.iBalance = sign;
                                Object var11_13 = null;
                                this.writeLock.unlock();
                                return;
                            }
                            case 1: {
                                NodeAVL r = x.child(store, !isleft);
                                int b = r.iBalance;
                                if (b * sign >= 0) {
                                    x.replace(store, this, r);
                                    NodeAVL child = r.child(store, isleft);
                                    x.set(store, !isleft, child);
                                    r.set(store, isleft, x);
                                    if (b == 0) {
                                        x.iBalance = sign;
                                        r.iBalance = -sign;
                                        break block29;
                                    } else {
                                        x.iBalance = 0;
                                        r.iBalance = 0;
                                        x = r;
                                        break;
                                    }
                                }
                                NodeAVL l = r.child(store, isleft);
                                x.replace(store, this, l);
                                b = l.iBalance;
                                r.set(store, isleft, l.child(store, !isleft));
                                l.set(store, !isleft, r);
                                x.set(store, !isleft, l.child(store, isleft));
                                l.set(store, isleft, x);
                                x.iBalance = b == sign ? -sign : 0;
                                r.iBalance = b == -sign ? sign : 0;
                                l.iBalance = 0;
                                x = l;
                                break;
                            }
                        }
                        isleft = x.isFromLeft(store);
                        n = x.nParent;
                    }
                    break block30;
                }
                catch (Throwable throwable) {
                    Object var11_16 = null;
                    this.writeLock.unlock();
                    throw throwable;
                }
            }
            Object var11_14 = null;
            this.writeLock.unlock();
            return;
        }
        Object var11_15 = null;
        this.writeLock.unlock();
    }

    NodeAVL next(PersistentStore store, NodeAVL x) {
        NodeAVL r = x.nRight;
        if (r != null) {
            x = r;
            NodeAVL l = x.nLeft;
            while (l != null) {
                x = l;
                l = x.nLeft;
            }
            return x;
        }
        NodeAVL ch = x;
        x = x.nParent;
        while (x != null && ch == x.nRight) {
            ch = x;
            x = x.nParent;
        }
        return x;
    }

    NodeAVL last(PersistentStore store, NodeAVL x) {
        if (x == null) {
            return null;
        }
        NodeAVL left = x.nLeft;
        if (left != null) {
            x = left;
            NodeAVL right = x.nRight;
            while (right != null) {
                x = right;
                right = x.nRight;
            }
            return x;
        }
        NodeAVL ch = x;
        x = x.nParent;
        while (x != null && ch.equals(x.nLeft)) {
            ch = x;
            x = x.nParent;
        }
        return x;
    }

    void balance(PersistentStore store, NodeAVL x, boolean isleft) {
        while (true) {
            int sign = isleft ? 1 : -1;
            switch (x.iBalance * sign) {
                case 1: {
                    x.iBalance = 0;
                    return;
                }
                case 0: {
                    x.iBalance = -sign;
                    break;
                }
                case -1: {
                    NodeAVL l;
                    NodeAVL nodeAVL = l = isleft ? x.nLeft : x.nRight;
                    if (l.iBalance == -sign) {
                        x.replace(store, this, l);
                        x.set(store, isleft, l.child(store, !isleft));
                        l.set(store, !isleft, x);
                        x.iBalance = 0;
                        l.iBalance = 0;
                    } else {
                        NodeAVL r = !isleft ? l.nLeft : l.nRight;
                        x.replace(store, this, r);
                        l.set(store, !isleft, r.child(store, isleft));
                        r.set(store, isleft, l);
                        x.set(store, isleft, r.child(store, !isleft));
                        r.set(store, !isleft, x);
                        int rb = r.iBalance;
                        x.iBalance = rb == -sign ? sign : 0;
                        l.iBalance = rb == sign ? -sign : 0;
                        r.iBalance = 0;
                    }
                    return;
                }
            }
            if (x.nParent == null) {
                return;
            }
            isleft = x.nParent == null || x == x.nParent.nLeft;
            x = x.nParent;
        }
    }
}

