/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.IOException;
import java.io.InputStream;

public final class CountdownInputStream
extends InputStream {
    private long count;
    private InputStream input;

    public CountdownInputStream(InputStream is) {
        this.input = is;
    }

    public int read() throws IOException {
        if (this.count <= 0L) {
            return -1;
        }
        int b = this.input.read();
        if (b >= 0) {
            --this.count;
        }
        return b;
    }

    public int read(byte[] buf) throws IOException {
        int r;
        if (this.count <= 0L) {
            return -1;
        }
        int len = buf.length;
        if ((long)len > this.count) {
            len = (int)this.count;
        }
        if ((r = this.input.read(buf, 0, len)) > 0) {
            this.count -= (long)r;
        }
        return r;
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        int r;
        if (this.count <= 0L) {
            return -1;
        }
        if ((long)len > this.count) {
            len = (int)this.count;
        }
        if ((r = this.input.read(buf, off, len)) > 0) {
            this.count -= (long)r;
        }
        return r;
    }

    public void close() throws IOException {
        this.input.close();
    }

    public long getCount() {
        return this.count;
    }

    public void setCount(long count) {
        this.count = count;
    }
}

