/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import org.hsqldb.lib.CountdownInputStream;
import org.hsqldb.lib.ReaderInputStream;

public class DataOutputStream
extends BufferedOutputStream {
    byte[] tempBuffer = new byte[8];

    public DataOutputStream(OutputStream stream) {
        super(stream, 8);
    }

    public final void writeByte(int v) throws IOException {
        this.write(v);
    }

    public final void writeInt(int v) throws IOException {
        int count = 0;
        this.tempBuffer[count++] = (byte)(v >>> 24);
        this.tempBuffer[count++] = (byte)(v >>> 16);
        this.tempBuffer[count++] = (byte)(v >>> 8);
        this.tempBuffer[count++] = (byte)v;
        this.write(this.tempBuffer, 0, count);
    }

    public final void writeLong(long v) throws IOException {
        this.writeInt((int)(v >>> 32));
        this.writeInt((int)v);
    }

    public void writeChar(int v) throws IOException {
        int count = 0;
        this.tempBuffer[count++] = (byte)(v >>> 8);
        this.tempBuffer[count++] = (byte)v;
        this.write(this.tempBuffer, 0, count);
    }

    public void writeChars(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char v = s.charAt(i);
            int count = 0;
            this.tempBuffer[count++] = (byte)(v >>> 8);
            this.tempBuffer[count++] = (byte)v;
            this.write(this.tempBuffer, 0, count);
        }
    }

    public void writeChars(char[] c) throws IOException {
        this.writeChars(c, c.length);
    }

    public void writeChars(char[] c, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            char v = c[i];
            int count = 0;
            this.tempBuffer[count++] = (byte)(v >>> 8);
            this.tempBuffer[count++] = (byte)v;
            this.write(this.tempBuffer, 0, count);
        }
    }

    public void write(Reader reader, long length) throws IOException {
        ReaderInputStream inputStream = new ReaderInputStream(reader);
        this.write(inputStream, length * 2L);
    }

    public void write(InputStream inputStream, long length) throws IOException {
        CountdownInputStream countStream = new CountdownInputStream(inputStream);
        countStream.setCount(length);
        byte[] data = new byte[1024];
        while (true) {
            int count;
            if ((count = countStream.read(data)) < 1) {
                if (countStream.getCount() == 0L) break;
                throw new EOFException();
            }
            this.write(data, 0, count);
        }
    }
}

