/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import org.hsqldb.Database;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.persist.RandomAccessInterface;
import org.hsqldb.persist.ScaledRAFile;
import org.hsqldb.persist.ScaledRAFileSimple;
import org.hsqldb.store.BitMap;

public class RAShadowFile {
    final Database database;
    final String pathName;
    final RandomAccessInterface source;
    RandomAccessInterface dest;
    final int pageSize;
    final long maxSize;
    final BitMap bitMap;
    boolean zeroPageSet;
    HsqlByteArrayOutputStream byteArrayOutputStream = new HsqlByteArrayOutputStream(new byte[0]);

    RAShadowFile(Database database, RandomAccessInterface source, String pathName, long maxSize, int pageSize) {
        this.database = database;
        this.pathName = pathName;
        this.source = source;
        this.pageSize = pageSize;
        this.maxSize = maxSize;
        int bitSize = (int)(maxSize / (long)pageSize);
        if (maxSize % (long)pageSize != 0L) {
            ++bitSize;
        }
        this.bitMap = new BitMap(bitSize);
    }

    void copy(long fileOffset, int size) throws IOException {
        if (!this.zeroPageSet) {
            this.copy(0);
            this.bitMap.set(0);
            this.zeroPageSet = true;
        }
        if (fileOffset >= this.maxSize) {
            return;
        }
        long endOffset = fileOffset + (long)size;
        int startPageOffset = (int)(fileOffset / (long)this.pageSize);
        int endPageOffset = (int)(endOffset / (long)this.pageSize);
        if (endOffset % (long)this.pageSize == 0L) {
            --endPageOffset;
        }
        while (startPageOffset <= endPageOffset) {
            this.copy(startPageOffset);
            ++startPageOffset;
        }
    }

    private void copy(int pageOffset) throws IOException {
        if (this.bitMap.set(pageOffset) == 1) {
            return;
        }
        long position = (long)pageOffset * (long)this.pageSize;
        int readSize = this.pageSize;
        if (this.maxSize - position < (long)this.pageSize) {
            readSize = (int)(this.maxSize - position);
        }
        if (this.dest == null) {
            this.open();
        }
        long writePos = this.dest.length();
        try {
            try {
                byte[] buffer = new byte[this.pageSize + 12];
                this.byteArrayOutputStream.setBuffer(buffer);
                this.byteArrayOutputStream.writeInt(this.pageSize);
                this.byteArrayOutputStream.writeLong(position);
                this.source.seek(position);
                this.source.read(buffer, 12, readSize);
                this.dest.seek(writePos);
                this.dest.write(buffer, 0, buffer.length);
            }
            catch (Throwable t) {
                this.bitMap.unset(pageOffset);
                this.dest.seek(0L);
                this.dest.setLength(writePos);
                this.close();
                this.database.logger.logWarningEvent("pos" + position + " " + readSize, t);
                throw JavaSystem.toIOException(t);
            }
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            throw throwable;
        }
    }

    private void open() throws IOException {
        this.dest = this.database.logger.isStoredFileAccess() ? ScaledRAFile.newScaledRAFile(this.database, this.pathName, false, 3) : new ScaledRAFileSimple(this.pathName, "rws");
    }

    void close() throws IOException {
        if (this.dest != null) {
            this.dest.synch();
            this.dest.close();
            this.dest = null;
        }
    }

    public void synch() {
        if (this.dest != null) {
            this.dest.synch();
        }
    }

    private static RandomAccessInterface getStorage(Database database, String pathName, String openMode) throws IOException {
        if (database.logger.isStoredFileAccess()) {
            return ScaledRAFile.newScaledRAFile(database, pathName, openMode.equals("r"), 3);
        }
        return new ScaledRAFileSimple(pathName, openMode);
    }

    public static void restoreFile(Database database, String sourceName, String destName) throws IOException {
        RandomAccessInterface source = RAShadowFile.getStorage(database, sourceName, "r");
        RandomAccessInterface dest = RAShadowFile.getStorage(database, destName, "rw");
        while (source.getFilePointer() != source.length()) {
            int size = source.readInt();
            long position = source.readLong();
            byte[] buffer = new byte[size];
            source.read(buffer, 0, buffer.length);
            dest.seek(position);
            dest.write(buffer, 0, buffer.length);
        }
        source.close();
        dest.synch();
        dest.close();
    }
}

