/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.hsqldb.lib.DataOutputStream;

class OdbcPacketOutputStream
extends java.io.DataOutputStream {
    private ByteArrayOutputStream byteArrayOutputStream;
    private ByteArrayOutputStream stringWriterOS = new ByteArrayOutputStream();
    private java.io.DataOutputStream stringWriterDos = new java.io.DataOutputStream(this.stringWriterOS);
    private int packetStart = 0;

    public int getSize() {
        return this.written - this.packetStart;
    }

    synchronized void write(String s) throws IOException {
        this.write(s, true);
    }

    synchronized void write(String s, boolean nullTerm) throws IOException {
        this.stringWriterDos.writeUTF(s);
        this.write(this.stringWriterOS.toByteArray(), 2, this.stringWriterOS.size() - 2);
        this.stringWriterOS.reset();
        if (nullTerm) {
            this.writeByte(0);
        }
    }

    synchronized void writeSized(String s) throws IOException {
        this.stringWriterDos.writeUTF(s);
        byte[] ba = this.stringWriterOS.toByteArray();
        this.stringWriterOS.reset();
        this.writeInt(ba.length - 2);
        this.write(ba, 2, ba.length - 2);
    }

    synchronized void reset() throws IOException {
        this.byteArrayOutputStream.reset();
        this.packetStart = this.written;
        this.writeInt(-1);
    }

    static OdbcPacketOutputStream newOdbcPacketOutputStream() throws IOException {
        return new OdbcPacketOutputStream(new ByteArrayOutputStream());
    }

    protected OdbcPacketOutputStream(ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        super(byteArrayOutputStream);
        this.byteArrayOutputStream = byteArrayOutputStream;
        this.reset();
    }

    synchronized int xmit(char packetType, DataOutputStream destinationStream) throws IOException {
        byte[] ba = this.byteArrayOutputStream.toByteArray();
        ba[0] = (byte)(ba.length >> 24);
        ba[1] = (byte)(ba.length >> 16);
        ba[2] = (byte)(ba.length >> 8);
        ba[3] = (byte)ba.length;
        this.reset();
        destinationStream.writeByte(packetType);
        destinationStream.write(ba);
        destinationStream.flush();
        return ba.length;
    }

    public synchronized void close() throws IOException {
        super.close();
        this.stringWriterDos.close();
    }

    public synchronized void writeByteChar(char c) throws IOException {
        this.writeByte(c);
    }
}

