/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.server;

import java.io.IOException;
import java.util.Locale;
import org.hsqldb.ColumnBase;
import org.hsqldb.lib.DataOutputStream;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.server.OdbcPacketInputStream;
import org.hsqldb.server.OdbcPacketOutputStream;
import org.hsqldb.server.RecoverableOdbcFailure;

public class OdbcUtil {
    static final int ODBC_SM_DATABASE = 64;
    static final int ODBC_SM_USER = 32;
    static final int ODBC_SM_OPTIONS = 64;
    static final int ODBC_SM_UNUSED = 64;
    static final int ODBC_SM_TTY = 64;
    static final int ODBC_AUTH_REQ_PASSWORD = 3;
    static final int ODBC_AUTH_REQ_OK = 0;
    static String[][] hardcodedParams = new String[][]{{"client_encoding", "SQL_ASCII"}, {"DateStyle", "ISO, MDY"}, {"integer_datetimes", "on"}, {"is_superuser", "on"}, {"server_encoding", "SQL_ASCII"}, {"server_version", "8.3.1"}, {"session_authorization", "blaine"}, {"standard_conforming_strings", "off"}, {"TimeZone", "US/Eastern"}};
    static final int ODBC_SIMPLE_MODE = 0;
    static final int ODBC_EXTENDED_MODE = 1;
    static final int ODBC_EXT_RECOVER_MODE = 2;
    static final int ODBC_SEVERITY_FATAL = 1;
    static final int ODBC_SEVERITY_ERROR = 2;
    static final int ODBC_SEVERITY_PANIC = 3;
    static final int ODBC_SEVERITY_WARNING = 4;
    static final int ODBC_SEVERITY_NOTICE = 5;
    static final int ODBC_SEVERITY_DEBUG = 6;
    static final int ODBC_SEVERITY_INFO = 7;
    static final int ODBC_SEVERITY_LOG = 8;
    static IntKeyHashMap odbcSeverityMap = new IntKeyHashMap();

    static void validateInputPacketSize(OdbcPacketInputStream p) throws RecoverableOdbcFailure {
        int remaining = -1;
        try {
            remaining = p.available();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (remaining < 1) {
            return;
        }
        throw new RecoverableOdbcFailure("Client supplied bad length for " + p.packetType + " packet.  " + remaining + " bytes available after processing", "Bad length for " + p.packetType + " packet.  " + remaining + " extra bytes", "08P01");
    }

    static String echoBackReplyString(String inCommand, int retval) {
        int firstWhiteSpace;
        String uc = inCommand.trim().toUpperCase(Locale.ENGLISH);
        for (firstWhiteSpace = 0; firstWhiteSpace < uc.length() && !Character.isWhitespace(uc.charAt(firstWhiteSpace)); ++firstWhiteSpace) {
        }
        StringBuffer replyString = new StringBuffer(uc.substring(0, firstWhiteSpace));
        String keyword = replyString.toString();
        if (keyword.equals("UPDATE") || keyword.equals("DELETE")) {
            replyString.append(" " + retval);
        } else if (keyword.equals("CREATE") || keyword.equals("DROP")) {
            int wordEnd;
            int wordStart;
            for (wordStart = firstWhiteSpace; wordStart < uc.length() && Character.isWhitespace(uc.charAt(wordStart)); ++wordStart) {
            }
            for (wordEnd = wordStart; wordEnd < uc.length() && Character.isWhitespace(uc.charAt(wordEnd)); ++wordEnd) {
            }
            replyString.append(" " + uc.substring(wordStart, wordEnd));
        } else if (keyword.equals("INSERT")) {
            replyString.append(" 0 " + retval);
        }
        return replyString.toString();
    }

    static void writeParam(String key, String val, DataOutputStream hOutStream) throws IOException {
        OdbcPacketOutputStream alertPacket = OdbcPacketOutputStream.newOdbcPacketOutputStream();
        alertPacket.write(key);
        alertPacket.write(val);
        alertPacket.xmit('S', hOutStream);
        alertPacket.close();
    }

    static void alertClient(int severity, String message, DataOutputStream hOutStream) throws IOException {
        OdbcUtil.alertClient(severity, message, null, hOutStream);
    }

    static void alertClient(int severity, String message, String sqlStateCode, DataOutputStream hOutStream) throws IOException {
        if (sqlStateCode == null) {
            sqlStateCode = "XX000";
        }
        if (!odbcSeverityMap.containsKey(severity)) {
            throw new IllegalArgumentException("Unknown severity value (" + severity + ')');
        }
        OdbcPacketOutputStream alertPacket = OdbcPacketOutputStream.newOdbcPacketOutputStream();
        alertPacket.write("S" + odbcSeverityMap.get(severity));
        if (severity < 5) {
            alertPacket.write("C" + sqlStateCode);
        }
        alertPacket.write("M" + message);
        alertPacket.writeByte(0);
        alertPacket.xmit(severity < 5 ? (char)'E' : 'N', hOutStream);
        alertPacket.close();
    }

    static String revertMungledPreparedQuery(String inQuery) {
        return inQuery.replaceAll("\\$\\d+", "?");
    }

    public static int getTableOidForColumn(int colIndex, ResultMetaData md) {
        if (!md.isTableColumn(colIndex)) {
            return 0;
        }
        ColumnBase col = md.columns[colIndex];
        int hashCode = (col.getSchemaNameString() + '.' + col.getTableNameString()).hashCode();
        if (hashCode < 0) {
            hashCode *= -1;
        }
        return hashCode;
    }

    public static short getIdForColumn(int colIndex, ResultMetaData md) {
        if (!md.isTableColumn(colIndex)) {
            return 0;
        }
        short hashCode = (short)md.getGeneratedColumnNames()[colIndex].hashCode();
        if (hashCode < 0) {
            hashCode = (short)(hashCode * -1);
        }
        return hashCode;
    }

    public static String hexCharsToOctalOctets(String hexChars) {
        int chars = hexChars.length();
        if (chars != chars / 2 * 2) {
            throw new IllegalArgumentException("Hex character lists contains an odd number of characters: " + chars);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < chars; ++i) {
            int octet = 0;
            char c = hexChars.charAt(i);
            if (c >= 'a' && c <= 'f') {
                octet += 10 + c - 97;
            } else if (c >= 'A' && c <= 'F') {
                octet += 10 + c - 65;
            } else if (c >= '0' && c <= '9') {
                octet += c - 48;
            } else {
                throw new IllegalArgumentException("Non-hex character in input at offset " + i + ": " + c);
            }
            octet <<= 4;
            c = hexChars.charAt(++i);
            if (c >= 'a' && c <= 'f') {
                octet += 10 + c - 97;
            } else if (c >= 'A' && c <= 'F') {
                octet += 10 + c - 65;
            } else if (c >= '0' && c <= '9') {
                octet += c - 48;
            } else {
                throw new IllegalArgumentException("Non-hex character in input at offset " + i + ": " + c);
            }
            sb.append('\\');
            sb.append((char)(48 + (octet >> 6)));
            sb.append((char)(48 + (octet >> 3 & 7)));
            sb.append((char)(48 + (octet & 7)));
        }
        return sb.toString();
    }

    public static void main(String[] sa) {
        System.out.println("(" + OdbcUtil.hexCharsToOctalOctets(sa[0]) + ')');
    }

    static {
        odbcSeverityMap.put(1, "FATAL");
        odbcSeverityMap.put(2, "ERROR");
        odbcSeverityMap.put(3, "PANIC");
        odbcSeverityMap.put(4, "WARNING");
        odbcSeverityMap.put(5, "NOTICE");
        odbcSeverityMap.put(6, "DEBUG");
        odbcSeverityMap.put(7, "INFO");
        odbcSeverityMap.put(8, "LOG");
    }
}

