/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.backgroundtask;

import com.liferay.portal.DuplicateLockException;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutor;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskResult;
import com.liferay.portal.kernel.backgroundtask.DelegatingBackgroundTaskExecutor;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.BackgroundTask;
import com.liferay.portal.model.Lock;
import com.liferay.portal.service.LockLocalServiceUtil;

public class SerialBackgroundTaskExecutor
extends DelegatingBackgroundTaskExecutor {
    private static Log _log = LogFactoryUtil.getLog(SerialBackgroundTaskExecutor.class);

    public SerialBackgroundTaskExecutor(BackgroundTaskExecutor backgroundTaskExecutor) {
        super(backgroundTaskExecutor);
    }

    @Override
    public BackgroundTaskResult execute(BackgroundTask backgroundTask) throws Exception {
        Lock lock = null;
        String owner = String.valueOf(backgroundTask.getName()) + "#" + backgroundTask.getBackgroundTaskId();
        try {
            if (this.isSerial()) {
                lock = this.acquireLock(backgroundTask, owner);
            }
            BackgroundTaskExecutor backgroundTaskExecutor = this.getBackgroundTaskExecutor();
            BackgroundTaskResult backgroundTaskResult = backgroundTaskExecutor.execute(backgroundTask);
            return backgroundTaskResult;
        }
        finally {
            if (lock != null) {
                LockLocalServiceUtil.unlock(BackgroundTaskExecutor.class.getName(), backgroundTask.getTaskExecutorClassName(), owner);
            }
        }
    }

    protected Lock acquireLock(BackgroundTask backgroundTask, String owner) throws DuplicateLockException {
        Lock lock = null;
        while (true) {
            try {
                lock = LockLocalServiceUtil.lock(BackgroundTaskExecutor.class.getName(), backgroundTask.getTaskExecutorClassName(), owner);
            }
            catch (SystemException se) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Unable to acquire acquiring lock", se);
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            break;
        }
        if (!lock.isNew()) {
            throw new DuplicateLockException(lock);
        }
        return lock;
    }
}

