/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.dao.search;

import com.liferay.portal.kernel.dao.search.TextSearchEntry;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.theme.ThemeDisplay;
import java.text.Format;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;

public class DateSearchEntry
extends TextSearchEntry {
    private Date _date;
    private Locale _locale;
    private TimeZone _timeZone;

    public Date getDate() {
        return this._date;
    }

    @Override
    public String getName(PageContext pageContext) {
        if (Validator.isNotNull(this._date)) {
            Object[] localeAndTimeZone = this.getLocaleAndTimeZone(pageContext);
            Format dateFormatDateTime = FastDateFormatFactoryUtil.getDateTime((Locale)localeAndTimeZone[0], (TimeZone)localeAndTimeZone[1]);
            StringBundler sb = new StringBundler(5);
            sb.append("<span onmouseover=\"Liferay.Portal.ToolTip.show(this, '");
            sb.append(dateFormatDateTime.format(this._date));
            sb.append("')\">");
            if (this._date.before(new Date())) {
                sb.append(LanguageUtil.format(pageContext, "x-ago", (Object)LanguageUtil.getTimeDescription(pageContext, System.currentTimeMillis() - this._date.getTime(), true)));
            } else {
                sb.append(LanguageUtil.format(pageContext, "within-x", (Object)LanguageUtil.getTimeDescription(pageContext, this._date.getTime() - System.currentTimeMillis(), true)));
            }
            sb.append("</span>");
            return sb.toString();
        }
        return "";
    }

    public void setDate(Date date) {
        this._date = date;
    }

    protected Object[] getLocaleAndTimeZone(PageContext pageContext) {
        if (this._locale != null && this._timeZone != null) {
            return new Object[]{this._locale, this._timeZone};
        }
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this._locale = themeDisplay.getLocale();
        this._timeZone = themeDisplay.getTimeZone();
        return new Object[]{this._locale, this._timeZone};
    }
}

