/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.io;

import com.liferay.portal.kernel.nio.charset.CharsetEncoderUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;

public class ReaderInputStream
extends InputStream {
    private static final int _DEFAULT_INTPUT_BUFFER_SIZE = 128;
    private static final int _DEFAULT_OUTPUT_BUFFER_SIZE = 1024;
    private CharsetEncoder _charsetEncoder;
    private String _charsetName;
    private CharBuffer _inputBuffer;
    private int _maxBytesPerChar;
    private ByteBuffer _outputBuffer;
    private Reader _reader;

    public ReaderInputStream(Reader reader) {
        this(reader, "UTF-8", 128, 1024);
    }

    public ReaderInputStream(Reader reader, String charsetName) {
        this(reader, charsetName, 128, 1024);
    }

    public ReaderInputStream(Reader reader, String charsetName, int inputBufferSize, int outputBufferSize) {
        this._reader = reader;
        this._charsetName = charsetName;
        if (inputBufferSize <= 0) {
            throw new IllegalArgumentException("Input buffer size " + inputBufferSize + " must be a positive number");
        }
        this._inputBuffer = CharBuffer.allocate(inputBufferSize);
        this._charsetEncoder = CharsetEncoderUtil.getCharsetEncoder(charsetName);
        this._maxBytesPerChar = (int)Math.ceil(this._charsetEncoder.maxBytesPerChar());
        if (outputBufferSize < this._maxBytesPerChar) {
            throw new IllegalArgumentException("Output buffer size " + outputBufferSize + " is less than " + this._maxBytesPerChar);
        }
        this._outputBuffer = ByteBuffer.allocate(outputBufferSize);
        this._outputBuffer.flip();
    }

    @Override
    public int available() {
        return this._outputBuffer.remaining() + this._inputBuffer.position();
    }

    @Override
    public void close() throws IOException {
        if (this._inputBuffer != null) {
            this._inputBuffer.clear();
            this._inputBuffer = null;
        }
        if (this._outputBuffer != null) {
            this._outputBuffer.clear();
            this._outputBuffer = null;
        }
        this._reader.close();
    }

    public String getEncoding() {
        return this._charsetName;
    }

    @Override
    public int read() throws IOException {
        byte[] bytes = new byte[1];
        int result = this.read(bytes, 0, 1);
        if (result == 1) {
            return bytes[0];
        }
        return -1;
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        return this.read(bytes, 0, bytes.length);
    }

    @Override
    public int read(byte[] bytes, int offset, int length) throws IOException {
        if (bytes == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || length < 0 || length > bytes.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return 0;
        }
        int originalLength = length;
        while (length > 0) {
            int blockSize = Math.min(this._outputBuffer.remaining(), length);
            if (blockSize > 0) {
                this._outputBuffer.get(bytes, offset, blockSize);
                offset += blockSize;
                if ((length -= blockSize) == 0) break;
            }
            int inputPosition = this._inputBuffer.position();
            int result = this._reader.read(this._inputBuffer.array(), inputPosition, this._inputBuffer.remaining());
            if (result != -1) {
                this._inputBuffer.position(inputPosition + result);
            }
            this._inputBuffer.flip();
            int inputRemaining = this._inputBuffer.remaining();
            if (inputRemaining <= 0) break;
            if (inputRemaining * this._maxBytesPerChar < length) {
                ByteBuffer byteBuffer = ByteBuffer.wrap(bytes, offset, length);
                this._charsetEncoder.encode(this._inputBuffer, byteBuffer, true);
                int outputRemaining = byteBuffer.remaining();
                offset += length - outputRemaining;
                length = outputRemaining;
            } else {
                this._outputBuffer.clear();
                this._charsetEncoder.encode(this._inputBuffer, this._outputBuffer, true);
                this._outputBuffer.flip();
            }
            this._inputBuffer.compact();
        }
        int result = originalLength - length;
        if (result == 0) {
            return -1;
        }
        return result;
    }

    @Override
    public long skip(long length) throws IOException {
        if (length < 0L) {
            throw new IllegalArgumentException();
        }
        long originalLength = length;
        while (length > 0L) {
            int blockSize = (int)Math.min((long)this._outputBuffer.remaining(), length);
            if (blockSize > 0) {
                this._outputBuffer.position(this._outputBuffer.position() + blockSize);
                if ((length -= (long)blockSize) == 0L) break;
            }
            int inputPosition = this._inputBuffer.position();
            int result = this._reader.read(this._inputBuffer.array(), inputPosition, this._inputBuffer.remaining());
            if (result != -1) {
                this._inputBuffer.position(inputPosition + result);
            }
            this._inputBuffer.flip();
            if (this._inputBuffer.remaining() <= 0) break;
            this._outputBuffer.clear();
            this._charsetEncoder.encode(this._inputBuffer, this._outputBuffer, true);
            this._outputBuffer.flip();
            this._inputBuffer.compact();
        }
        return originalLength - length;
    }
}

