/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.language;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.language.LanguageWrapper;
import com.liferay.portal.kernel.security.pacl.permission.PortalRuntimePermission;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;

public class LanguageUtil {
    private static Language _language;

    public static String format(Locale locale, String pattern, List<Object> arguments) {
        return LanguageUtil.getLanguage().format(locale, pattern, arguments);
    }

    public static String format(Locale locale, String pattern, Object argument) {
        return LanguageUtil.getLanguage().format(locale, pattern, argument);
    }

    public static String format(Locale locale, String pattern, Object argument, boolean translateArguments) {
        return LanguageUtil.getLanguage().format(locale, pattern, argument, translateArguments);
    }

    public static String format(Locale locale, String pattern, Object[] arguments) {
        return LanguageUtil.getLanguage().format(locale, pattern, arguments);
    }

    public static String format(Locale locale, String pattern, Object[] arguments, boolean translateArguments) {
        return LanguageUtil.getLanguage().format(locale, pattern, arguments, translateArguments);
    }

    public static String format(PageContext pageContext, String pattern, LanguageWrapper argument) {
        return LanguageUtil.getLanguage().format(pageContext, pattern, argument);
    }

    public static String format(PageContext pageContext, String pattern, LanguageWrapper argument, boolean translateArguments) {
        return LanguageUtil.getLanguage().format(pageContext, pattern, argument, translateArguments);
    }

    public static String format(PageContext pageContext, String pattern, LanguageWrapper[] arguments) {
        return LanguageUtil.getLanguage().format(pageContext, pattern, arguments);
    }

    public static String format(PageContext pageContext, String pattern, LanguageWrapper[] arguments, boolean translateArguments) {
        return LanguageUtil.getLanguage().format(pageContext, pattern, arguments, translateArguments);
    }

    public static String format(PageContext pageContext, String pattern, Object argument) {
        return LanguageUtil.getLanguage().format(pageContext, pattern, argument);
    }

    public static String format(PageContext pageContext, String pattern, Object argument, boolean translateArguments) {
        return LanguageUtil.getLanguage().format(pageContext, pattern, argument, translateArguments);
    }

    public static String format(PageContext pageContext, String pattern, Object[] arguments) {
        return LanguageUtil.getLanguage().format(pageContext, pattern, arguments);
    }

    public static String format(PageContext pageContext, String pattern, Object[] arguments, boolean translateArguments) {
        return LanguageUtil.getLanguage().format(pageContext, pattern, arguments, translateArguments);
    }

    public static String format(PortletConfig portletConfig, Locale locale, String pattern, Object argument) {
        return LanguageUtil.getLanguage().format(portletConfig, locale, pattern, argument);
    }

    public static String format(PortletConfig portletConfig, Locale locale, String pattern, Object argument, boolean translateArguments) {
        return LanguageUtil.getLanguage().format(portletConfig, locale, pattern, argument, translateArguments);
    }

    public static String format(PortletConfig portletConfig, Locale locale, String pattern, Object[] arguments) {
        return LanguageUtil.getLanguage().format(portletConfig, locale, pattern, arguments);
    }

    public static String format(PortletConfig portletConfig, Locale locale, String pattern, Object[] arguments, boolean translateArguments) {
        return LanguageUtil.getLanguage().format(portletConfig, locale, pattern, arguments, translateArguments);
    }

    public static String get(Locale locale, String key) {
        return LanguageUtil.getLanguage().get(locale, key);
    }

    public static String get(Locale locale, String key, String defaultValue) {
        return LanguageUtil.getLanguage().get(locale, key, defaultValue);
    }

    public static String get(PageContext pageContext, String key) {
        return LanguageUtil.getLanguage().get(pageContext, key);
    }

    public static String get(PageContext pageContext, String key, String defaultValue) {
        return LanguageUtil.getLanguage().get(pageContext, key, defaultValue);
    }

    public static String get(PortletConfig portletConfig, Locale locale, String key) {
        return LanguageUtil.getLanguage().get(portletConfig, locale, key);
    }

    public static String get(PortletConfig portletConfig, Locale locale, String key, String defaultValue) {
        return LanguageUtil.getLanguage().get(portletConfig, locale, key, defaultValue);
    }

    public static Locale[] getAvailableLocales() {
        return LanguageUtil.getLanguage().getAvailableLocales();
    }

    public static Locale[] getAvailableLocales(long groupId) {
        return LanguageUtil.getLanguage().getAvailableLocales(groupId);
    }

    public static String getBCP47LanguageId(HttpServletRequest request) {
        return LanguageUtil.getLanguage().getBCP47LanguageId(request);
    }

    public static String getBCP47LanguageId(Locale locale) {
        return LanguageUtil.getLanguage().getBCP47LanguageId(locale);
    }

    public static String getBCP47LanguageId(PortletRequest portletRequest) {
        return LanguageUtil.getLanguage().getBCP47LanguageId(portletRequest);
    }

    public static String getCharset(Locale locale) {
        return LanguageUtil.getLanguage().getCharset(locale);
    }

    public static Language getLanguage() {
        PortalRuntimePermission.checkGetBeanProperty(LanguageUtil.class);
        return _language;
    }

    public static String getLanguageId(HttpServletRequest request) {
        return LanguageUtil.getLanguage().getLanguageId(request);
    }

    public static String getLanguageId(Locale locale) {
        return LanguageUtil.getLanguage().getLanguageId(locale);
    }

    public static String getLanguageId(PortletRequest portletRequest) {
        return LanguageUtil.getLanguage().getLanguageId(portletRequest);
    }

    public static Locale getLocale(String languageCode) {
        return LanguageUtil.getLanguage().getLocale(languageCode);
    }

    public static Locale[] getSupportedLocales() {
        return LanguageUtil.getLanguage().getSupportedLocales();
    }

    public static String getTimeDescription(Locale locale, long milliseconds) {
        return LanguageUtil.getLanguage().getTimeDescription(locale, milliseconds);
    }

    public static String getTimeDescription(Locale locale, long milliseconds, boolean approximate) {
        return LanguageUtil.getLanguage().getTimeDescription(locale, milliseconds, approximate);
    }

    public static String getTimeDescription(Locale locale, Long milliseconds) {
        return LanguageUtil.getLanguage().getTimeDescription(locale, milliseconds);
    }

    public static String getTimeDescription(PageContext pageContext, long milliseconds) {
        return LanguageUtil.getLanguage().getTimeDescription(pageContext, milliseconds);
    }

    public static String getTimeDescription(PageContext pageContext, long milliseconds, boolean approximate) {
        return LanguageUtil.getLanguage().getTimeDescription(pageContext, milliseconds, approximate);
    }

    public static String getTimeDescription(PageContext pageContext, Long milliseconds) {
        return LanguageUtil.getLanguage().getTimeDescription(pageContext, milliseconds);
    }

    public static void init() {
        LanguageUtil.getLanguage().init();
    }

    public static boolean isAvailableLanguageCode(String languageCode) {
        return LanguageUtil.getLanguage().isAvailableLanguageCode(languageCode);
    }

    public static boolean isAvailableLocale(Locale locale) {
        return LanguageUtil.getLanguage().isAvailableLocale(locale);
    }

    public static boolean isAvailableLocale(long groupId, Locale locale) {
        return LanguageUtil.getLanguage().isAvailableLocale(groupId, locale);
    }

    public static boolean isAvailableLocale(long groupId, String languageId) {
        return LanguageUtil.getLanguage().isAvailableLocale(groupId, languageId);
    }

    public static boolean isAvailableLocale(String languageId) {
        return LanguageUtil.getLanguage().isAvailableLocale(languageId);
    }

    public static boolean isBetaLocale(Locale locale) {
        return LanguageUtil.getLanguage().isBetaLocale(locale);
    }

    public static boolean isDuplicateLanguageCode(String languageCode) {
        return LanguageUtil.getLanguage().isDuplicateLanguageCode(languageCode);
    }

    public static boolean isInheritLocales(long groupId) throws PortalException, SystemException {
        return LanguageUtil.getLanguage().isInheritLocales(groupId);
    }

    public static boolean isValidLanguageKey(Locale locale, String key) {
        String value = LanguageUtil.getLanguage().get(locale, key, "");
        return Validator.isNotNull(value);
    }

    public static void resetAvailableGroupLocales(long groupId) {
        LanguageUtil.getLanguage().resetAvailableGroupLocales(groupId);
    }

    public static void resetAvailableLocales(long companyId) {
        LanguageUtil.getLanguage().resetAvailableLocales(companyId);
    }

    public static void updateCookie(HttpServletRequest request, HttpServletResponse response, Locale locale) {
        LanguageUtil.getLanguage().updateCookie(request, response, locale);
    }

    public void setLanguage(Language language) {
        PortalRuntimePermission.checkSetBeanProperty(this.getClass());
        _language = language;
    }
}

