/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.lar;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataException;
import com.liferay.portal.kernel.lar.StagedModelDataHandler;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerRegistryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Attribute;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.StagedGroupedModel;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.model.TypedModel;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import java.util.List;
import java.util.Map;

public class StagedModelDataHandlerUtil {
    public static void deleteStagedModel(PortletDataContext portletDataContext, Element deletionElement) throws PortalException, SystemException {
        String className = deletionElement.attributeValue("class-name");
        String extraData = deletionElement.attributeValue("extra-data");
        String uuid = deletionElement.attributeValue("uuid");
        StagedModelDataHandler<?> stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler(className);
        if (stagedModelDataHandler != null) {
            stagedModelDataHandler.deleteStagedModel(uuid, portletDataContext.getScopeGroupId(), className, extraData);
        }
    }

    public static <T extends StagedModel> Element exportReferenceStagedModel(PortletDataContext portletDataContext, String referrerPortletId, T stagedModel) throws PortletDataException {
        StagedGroupedModel stagedGroupedModel;
        Element referenceElement = null;
        Portlet referrerPortlet = PortletLocalServiceUtil.getPortletById(referrerPortletId);
        if (stagedModel instanceof StagedGroupedModel && portletDataContext.isCompanyStagedGroupedModel(stagedGroupedModel = (StagedGroupedModel)stagedModel)) {
            referenceElement = portletDataContext.addReferenceElement((ClassedModel)referrerPortlet, portletDataContext.getExportDataRootElement(), stagedModel, stagedModel.getModelClass(), "dependency", true);
            return referenceElement;
        }
        StagedModelDataHandlerUtil.exportStagedModel(portletDataContext, stagedModel);
        referenceElement = portletDataContext.addReferenceElement((ClassedModel)referrerPortlet, portletDataContext.getExportDataRootElement(), stagedModel, stagedModel.getModelClass(), "dependency", false);
        return referenceElement;
    }

    public static <T extends StagedModel, U extends StagedModel> Element exportReferenceStagedModel(PortletDataContext portletDataContext, T referrerStagedModel, Class<?> referrerStagedModelClass, U stagedModel, Class<?> stagedModelClass, String referenceType) throws PortletDataException {
        Element referrerStagedModelElement = portletDataContext.getExportDataElement(referrerStagedModel, referrerStagedModelClass);
        return StagedModelDataHandlerUtil.exportReferenceStagedModel(portletDataContext, referrerStagedModel, referrerStagedModelElement, stagedModel, stagedModelClass, referenceType);
    }

    public static <T extends StagedModel, U extends StagedModel> Element exportReferenceStagedModel(PortletDataContext portletDataContext, T referrerStagedModel, Element referrerStagedModelElement, U stagedModel, Class<?> stagedModelClass, String referenceType) throws PortletDataException {
        StagedGroupedModel stagedGroupedModel;
        Element referenceElement = null;
        if (stagedModel instanceof StagedGroupedModel && portletDataContext.isCompanyStagedGroupedModel(stagedGroupedModel = (StagedGroupedModel)stagedModel)) {
            referenceElement = portletDataContext.addReferenceElement(referrerStagedModel, referrerStagedModelElement, stagedModel, stagedModelClass, "dependency", true);
            return referenceElement;
        }
        StagedModelDataHandlerUtil.exportStagedModel(portletDataContext, stagedModel);
        referenceElement = portletDataContext.addReferenceElement(referrerStagedModel, referrerStagedModelElement, stagedModel, stagedModelClass, referenceType, false);
        return referenceElement;
    }

    public static <T extends StagedModel, U extends StagedModel> Element exportReferenceStagedModel(PortletDataContext portletDataContext, T referrerStagedModel, U stagedModel, String referenceType) throws PortletDataException {
        return StagedModelDataHandlerUtil.exportReferenceStagedModel(portletDataContext, referrerStagedModel, referrerStagedModel.getModelClass(), stagedModel, stagedModel.getModelClass(), referenceType);
    }

    public static <T extends StagedModel> void exportStagedModel(PortletDataContext portletDataContext, T stagedModel) throws PortletDataException {
        StagedModelDataHandler<T> stagedModelDataHandler = StagedModelDataHandlerUtil._getStagedModelDataHandler(stagedModel);
        stagedModelDataHandler.exportStagedModel(portletDataContext, stagedModel);
    }

    public static <T extends StagedModel> String getDisplayName(T stagedModel) {
        StagedModelDataHandler<T> stagedModelDataHandler = StagedModelDataHandlerUtil._getStagedModelDataHandler(stagedModel);
        if (stagedModelDataHandler == null) {
            return "";
        }
        return stagedModelDataHandler.getDisplayName(stagedModel);
    }

    public static Map<String, String> getReferenceAttributes(PortletDataContext portletDataContext, StagedModel stagedModel) {
        StagedModelDataHandler<StagedModel> stagedModelDataHandler = StagedModelDataHandlerUtil._getStagedModelDataHandler(stagedModel);
        return stagedModelDataHandler.getReferenceAttributes(portletDataContext, stagedModel);
    }

    public static <T extends StagedModel> void importReferenceStagedModel(PortletDataContext portletDataContext, T referrerStagedModel, Class<?> stagedModelClass, long classPK) throws PortletDataException {
        Element referenceElement = portletDataContext.getReferenceElement(referrerStagedModel, stagedModelClass, classPK);
        if (referenceElement == null) {
            return;
        }
        long groupId = GetterUtil.getLong(referenceElement.attributeValue("group-id"));
        if (portletDataContext.getSourceCompanyGroupId() == groupId && portletDataContext.getGroupId() != portletDataContext.getCompanyGroupId()) {
            StagedModelDataHandler<?> stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler(stagedModelClass.getName());
            stagedModelDataHandler.importCompanyStagedModel(portletDataContext, referenceElement);
            return;
        }
        Element referenceDataElement = portletDataContext.getReferenceDataElement(referrerStagedModel, stagedModelClass, classPK);
        StagedModelDataHandlerUtil.importStagedModel(portletDataContext, referenceDataElement);
    }

    public static void importReferenceStagedModels(PortletDataContext portletDataContext, Class<?> stagedModelClass) throws PortletDataException {
        Element importDataRootElement = portletDataContext.getImportDataRootElement();
        Element referencesElement = importDataRootElement.element("references");
        if (referencesElement == null) {
            return;
        }
        List<Element> referenceElements = referencesElement.elements();
        for (Element referenceElement : referenceElements) {
            String className = referenceElement.attributeValue("class-name");
            String stagedModelClassName = stagedModelClass.getName();
            if (!stagedModelClassName.equals(className)) continue;
            long groupId = GetterUtil.getLong(referenceElement.attributeValue("group-id"));
            if (portletDataContext.getSourceCompanyGroupId() == groupId && portletDataContext.getGroupId() != portletDataContext.getCompanyGroupId()) {
                StagedModelDataHandler<?> stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler(stagedModelClass.getName());
                stagedModelDataHandler.importCompanyStagedModel(portletDataContext, referenceElement);
                continue;
            }
            long classPK = GetterUtil.getLong(referenceElement.attributeValue("class-pk"));
            String stagedModelPath = ExportImportPathUtil.getModelPath(portletDataContext, stagedModelClass.getName(), classPK);
            StagedModel stagedModel = (StagedModel)portletDataContext.getZipEntryAsObject(stagedModelPath);
            StagedModelDataHandlerUtil.importStagedModel(portletDataContext, stagedModel);
        }
    }

    public static <T extends StagedModel> void importReferenceStagedModels(PortletDataContext portletDataContext, T referrerStagedModel, Class<?> stagedModelClass) throws PortletDataException {
        List<Element> referenceElements = portletDataContext.getReferenceElements(referrerStagedModel, stagedModelClass);
        for (Element referenceElement : referenceElements) {
            long classPK = GetterUtil.getLong(referenceElement.attributeValue("class-pk"));
            StagedModelDataHandlerUtil.importReferenceStagedModel(portletDataContext, referrerStagedModel, stagedModelClass, classPK);
        }
    }

    public static void importStagedModel(PortletDataContext portletDataContext, Element element) throws PortletDataException {
        StagedModel stagedModel = StagedModelDataHandlerUtil._getStagedModel(portletDataContext, element);
        StagedModelDataHandlerUtil.importStagedModel(portletDataContext, stagedModel);
    }

    public static <T extends StagedModel> void importStagedModel(PortletDataContext portletDataContext, T stagedModel) throws PortletDataException {
        StagedModelDataHandler<T> stagedModelDataHandler = StagedModelDataHandlerUtil._getStagedModelDataHandler(stagedModel);
        stagedModelDataHandler.importStagedModel(portletDataContext, stagedModel);
    }

    private static StagedModel _getStagedModel(PortletDataContext portletDataContext, Element element) {
        String className;
        String path = element.attributeValue("path");
        StagedModel stagedModel = (StagedModel)portletDataContext.getZipEntryAsObject(element, path);
        Attribute classNameAttribute = element.attribute("class-name");
        if (classNameAttribute != null && stagedModel instanceof TypedModel && Validator.isNotNull(className = classNameAttribute.getValue())) {
            long classNameId = PortalUtil.getClassNameId(className);
            TypedModel typedModel = (TypedModel)((Object)stagedModel);
            typedModel.setClassNameId(classNameId);
        }
        return stagedModel;
    }

    private static <T extends StagedModel> StagedModelDataHandler<T> _getStagedModelDataHandler(T stagedModel) {
        T classedModel = stagedModel;
        StagedModelDataHandler<?> stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler(classedModel.getModelClassName());
        return stagedModelDataHandler;
    }
}

