/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.resiliency.spi.remote;

import com.liferay.portal.kernel.deploy.hot.DependencyManagementThreadLocal;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.nio.intraband.RegistrationReference;
import com.liferay.portal.kernel.nio.intraband.welder.Welder;
import com.liferay.portal.kernel.nio.intraband.welder.WelderFactoryUtil;
import com.liferay.portal.kernel.process.ProcessCallable;
import com.liferay.portal.kernel.process.ProcessException;
import com.liferay.portal.kernel.process.ProcessExecutor;
import com.liferay.portal.kernel.process.log.ProcessOutputStream;
import com.liferay.portal.kernel.resiliency.mpi.MPI;
import com.liferay.portal.kernel.resiliency.mpi.MPIHelperUtil;
import com.liferay.portal.kernel.resiliency.spi.SPI;
import com.liferay.portal.kernel.resiliency.spi.SPIConfiguration;
import com.liferay.portal.kernel.resiliency.spi.agent.SPIAgent;
import com.liferay.portal.kernel.resiliency.spi.agent.SPIAgentFactoryUtil;
import com.liferay.portal.kernel.resiliency.spi.provider.SPISynchronousQueueUtil;
import com.liferay.portal.kernel.util.ReflectionUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;

public abstract class RemoteSPI
implements ProcessCallable<SPI>,
Remote,
SPI {
    protected final MPI mpi;
    protected RegistrationReference registrationReference;
    protected volatile transient SPIAgent spiAgent;
    protected final SPIConfiguration spiConfiguration;
    protected final String uuid;
    protected final Welder welder;
    private static Log _log = LogFactoryUtil.getLog(RemoteSPI.class);

    public RemoteSPI(SPIConfiguration spiConfiguration) {
        this.spiConfiguration = spiConfiguration;
        this.mpi = MPIHelperUtil.getMPI();
        UUID uuidObject = UUID.randomUUID();
        this.uuid = uuidObject.toString();
        this.welder = WelderFactoryUtil.createWelder();
    }

    @Override
    public SPI call() throws ProcessException {
        try {
            ProcessExecutor.ProcessContext.attach(this.spiConfiguration.getSPIId(), this.spiConfiguration.getPingInterval(), new SPIShutdownHook());
            SPI spi = (SPI)UnicastRemoteObject.exportObject((Remote)this, 0);
            RegisterCallback registerCallback = new RegisterCallback(this.uuid, spi);
            ProcessOutputStream processOutputStream = ProcessExecutor.ProcessContext.getProcessOutputStream();
            processOutputStream.writeProcessCallable(registerCallback);
            this.registrationReference = this.welder.weld(MPIHelperUtil.getIntraband());
            ConcurrentMap<String, Object> attributes = ProcessExecutor.ProcessContext.getAttributes();
            attributes.put("SPI_INSTANCE_PUBLICATION_KEY", this);
            return spi;
        }
        catch (RemoteException re) {
            throw new ProcessException("Failed to export SPI as RMI stub.", re);
        }
        catch (IOException ioe) {
            throw new ProcessException(ioe);
        }
    }

    @Override
    public MPI getMPI() {
        return this.mpi;
    }

    @Override
    public RegistrationReference getRegistrationReference() {
        return this.registrationReference;
    }

    @Override
    public SPIAgent getSPIAgent() {
        if (this.spiAgent == null) {
            this.spiAgent = SPIAgentFactoryUtil.createSPIAgent(this.spiConfiguration, this.registrationReference);
        }
        return this.spiAgent;
    }

    @Override
    public SPIConfiguration getSPIConfiguration() {
        return this.spiConfiguration;
    }

    public String getUUID() {
        return this.uuid;
    }

    public Welder getWelder() {
        return this.welder;
    }

    @Override
    public boolean isAlive() {
        return true;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        System.setProperty("intraband.impl", objectInputStream.readUTF());
        System.setProperty("intraband.timeout.default", objectInputStream.readUTF());
        System.setProperty("intraband.welder.impl", objectInputStream.readUTF());
        System.setProperty("portal:liferay.home", objectInputStream.readUTF());
        System.setProperty("portal:auto.deploy.enabled", "false");
        System.setProperty("portal:cluster.link.enabled", "false");
        try {
            Field enabledField = ReflectionUtil.getDeclaredField(DependencyManagementThreadLocal.class, "_enabled");
            enabledField.set(null, new ThreadLocal<Boolean>(){

                @Override
                public Boolean get() {
                    return Boolean.FALSE;
                }
            });
        }
        catch (Exception e) {
            throw new IOException("Unable to disable dependency management", e);
        }
        System.setProperty("spi.id", "-" + this.spiConfiguration.getSPIId());
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeUTF(System.getProperty("intraband.impl"));
        objectOutputStream.writeUTF(System.getProperty("intraband.timeout.default"));
        objectOutputStream.writeUTF(System.getProperty("intraband.welder.impl"));
        objectOutputStream.writeUTF(System.getProperty("liferay.home"));
    }

    protected static class RegisterCallback
    implements ProcessCallable<SPI> {
        private static final long serialVersionUID = 1L;
        private final SPI _spi;
        private final String _spiUUID;

        public RegisterCallback(String spiUUID, SPI spi) {
            this._spiUUID = spiUUID;
            this._spi = spi;
        }

        @Override
        public SPI call() throws ProcessException {
            try {
                SPISynchronousQueueUtil.notifySynchronousQueue(this._spiUUID, this._spi);
            }
            catch (InterruptedException ie) {
                throw new ProcessException(ie);
            }
            return this._spi;
        }
    }

    protected class SPIShutdownHook
    implements ProcessExecutor.ShutdownHook {
        protected SPIShutdownHook() {
        }

        @Override
        public boolean shutdown(int shutdownCode, Throwable shutdownThrowable) {
            try {
                RemoteSPI.this.stop();
            }
            catch (RemoteException re) {
                _log.error("Unable to stop SPI", re);
            }
            try {
                RemoteSPI.this.destroy();
            }
            catch (RemoteException re) {
                _log.error("Unable to destroy SPI", re);
            }
            return true;
        }
    }
}

