/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.portal.NoSuchCountryException;
import com.liferay.portal.NoSuchModelException;
import com.liferay.portal.NoSuchRegionException;
import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BooleanClause;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.BooleanQueryFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.HitsProcessor;
import com.liferay.portal.kernel.search.HitsProcessorRegistryUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerPostProcessor;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngine;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.SearchPermissionChecker;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.facet.AssetEntriesFacet;
import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.search.facet.MultiValueFacet;
import com.liferay.portal.kernel.search.facet.ScopeFacet;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Address;
import com.liferay.portal.model.AttachedModel;
import com.liferay.portal.model.AuditedModel;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Country;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.GroupedModel;
import com.liferay.portal.model.Region;
import com.liferay.portal.model.ResourcedModel;
import com.liferay.portal.model.TrashedModel;
import com.liferay.portal.model.User;
import com.liferay.portal.model.WorkflowedModel;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.CountryServiceUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.RegionServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextThreadLocal;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.asset.AssetRendererFactoryRegistryUtil;
import com.liferay.portlet.asset.model.AssetCategory;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.model.AssetRendererFactory;
import com.liferay.portlet.asset.model.AssetTag;
import com.liferay.portlet.asset.service.AssetCategoryLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetEntryLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetTagLocalServiceUtil;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.util.DDMIndexerUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;
import com.liferay.portlet.expando.util.ExpandoBridgeIndexerUtil;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.ratings.model.RatingsStats;
import com.liferay.portlet.ratings.service.RatingsStatsLocalServiceUtil;
import com.liferay.portlet.trash.model.TrashEntry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletURL;

public abstract class BaseIndexer
implements Indexer {
    public static final int INDEX_FILTER_SEARCH_LIMIT = GetterUtil.getInteger(PropsUtil.get("index.filter.search.limit"));
    private static Log _log = LogFactoryUtil.getLog(BaseIndexer.class);
    private Document _document;
    private boolean _filterSearch;
    private boolean _indexerEnabled = true;
    private IndexerPostProcessor[] _indexerPostProcessors = new IndexerPostProcessor[0];
    private boolean _permissionAware;
    private String _searchEngineId;
    private boolean _stagingAware = true;

    public BaseIndexer() {
        this._document = new DocumentImpl();
    }

    @Override
    public void addRelatedEntryFields(Document document, Object obj) throws Exception {
    }

    @Override
    public void delete(long companyId, String uid) throws SearchException {
        try {
            SearchEngineUtil.deleteDocument(this.getSearchEngineId(), companyId, uid);
        }
        catch (SearchException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SearchException(e);
        }
    }

    @Override
    public void delete(Object obj) throws SearchException {
        try {
            this.doDelete(obj);
        }
        catch (SearchException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SearchException(e);
        }
    }

    @Override
    public Document getDocument(Object obj) throws SearchException {
        Document document;
        block6: {
            document = this.doGetDocument(obj);
            IndexerPostProcessor[] indexerPostProcessorArray = this._indexerPostProcessors;
            int n = this._indexerPostProcessors.length;
            int n2 = 0;
            while (n2 < n) {
                IndexerPostProcessor indexerPostProcessor = indexerPostProcessorArray[n2];
                indexerPostProcessor.postProcessDocument(document, obj);
                ++n2;
            }
            if (document != null) break block6;
            return null;
        }
        try {
            Map<String, Field> fields = document.getFields();
            Field groupIdField = fields.get("groupId");
            if (groupIdField != null) {
                long groupId = GetterUtil.getLong(groupIdField.getValue());
                this.addStagingGroupKeyword(document, groupId);
            }
            return document;
        }
        catch (SearchException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SearchException(e);
        }
    }

    @Override
    public BooleanQuery getFacetQuery(String className, SearchContext searchContext) throws Exception {
        BooleanQuery facetQuery = BooleanQueryFactoryUtil.create(searchContext);
        facetQuery.addExactTerm("entryClassName", className);
        if (searchContext.getUserId() > 0L) {
            SearchPermissionChecker searchPermissionChecker = SearchEngineUtil.getSearchPermissionChecker();
            facetQuery = (BooleanQuery)searchPermissionChecker.getPermissionQuery(searchContext.getCompanyId(), searchContext.getGroupIds(), searchContext.getUserId(), className, facetQuery, searchContext);
        }
        return facetQuery;
    }

    @Override
    public BooleanQuery getFullQuery(SearchContext searchContext) throws SearchException {
        try {
            searchContext.setSearchEngineId(this.getSearchEngineId());
            String[] entryClassNames = this.getClassNames();
            if (searchContext.isIncludeAttachments()) {
                entryClassNames = ArrayUtil.append(entryClassNames, DLFileEntry.class.getName());
            }
            if (searchContext.isIncludeDiscussions()) {
                entryClassNames = ArrayUtil.append(entryClassNames, MBMessage.class.getName());
                searchContext.setAttribute("discussion", Boolean.TRUE);
            }
            searchContext.setEntryClassNames(entryClassNames);
            if (searchContext.isIncludeAttachments() || searchContext.isIncludeDiscussions()) {
                searchContext.setAttribute("relatedEntryClassNames", (Serializable)this.getClassNames());
            }
            BooleanQuery contextQuery = BooleanQueryFactoryUtil.create(searchContext);
            this.addSearchAssetCategoryIds(contextQuery, searchContext);
            this.addSearchAssetTagNames(contextQuery, searchContext);
            this.addSearchEntryClassNames(contextQuery, searchContext);
            this.addSearchFolderId(contextQuery, searchContext);
            this.addSearchGroupId(contextQuery, searchContext);
            this.addSearchLayout(contextQuery, searchContext);
            this.addSearchUserId(contextQuery, searchContext);
            BooleanQuery fullQuery = this.createFullQuery(contextQuery, searchContext);
            fullQuery.setQueryConfig(searchContext.getQueryConfig());
            return fullQuery;
        }
        catch (SearchException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SearchException(e);
        }
    }

    @Override
    public IndexerPostProcessor[] getIndexerPostProcessors() {
        return this._indexerPostProcessors;
    }

    @Override
    public String getSearchEngineId() {
        SearchEngine searchEngine;
        if (this._searchEngineId != null) {
            return this._searchEngineId;
        }
        Class<?> clazz = this.getClass();
        String searchEngineId = GetterUtil.getString(PropsUtil.get("index.search.engine.id", new Filter(clazz.getName())));
        if (Validator.isNotNull(searchEngineId) && (searchEngine = SearchEngineUtil.getSearchEngine(searchEngineId)) != null) {
            this._searchEngineId = searchEngineId;
        }
        if (this._searchEngineId == null) {
            this._searchEngineId = SearchEngineUtil.getDefaultSearchEngineId();
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Search engine ID for " + clazz.getName() + " is " + searchEngineId);
        }
        return this._searchEngineId;
    }

    @Override
    public String getSortField(String orderByCol) {
        String sortField = this.doGetSortField(orderByCol);
        if (this._document.isDocumentSortableTextField(sortField)) {
            return DocumentImpl.getSortableFieldName(sortField);
        }
        return sortField;
    }

    @Override
    public String getSortField(String orderByCol, int sortType) {
        if (sortType == 7 || sortType == 5 || sortType == 4 || sortType == 6) {
            return DocumentImpl.getSortableFieldName(orderByCol);
        }
        return this.getSortField(orderByCol);
    }

    @Override
    public Summary getSummary(Document document, Locale locale, String snippet, PortletURL portletURL) throws SearchException {
        try {
            Summary summary = this.doGetSummary(document, locale, snippet, portletURL);
            IndexerPostProcessor[] indexerPostProcessorArray = this._indexerPostProcessors;
            int n = this._indexerPostProcessors.length;
            int n2 = 0;
            while (n2 < n) {
                IndexerPostProcessor indexerPostProcessor = indexerPostProcessorArray[n2];
                indexerPostProcessor.postProcessSummary(summary, document, locale, snippet, portletURL);
                ++n2;
            }
            return summary;
        }
        catch (SearchException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SearchException(e);
        }
    }

    @Override
    public boolean hasPermission(PermissionChecker permissionChecker, String entryClassName, long entryClassPK, String actionId) throws Exception {
        return true;
    }

    @Override
    public boolean isFilterSearch() {
        return this._filterSearch;
    }

    public boolean isIndexerEnabled() {
        return this._indexerEnabled;
    }

    @Override
    public boolean isPermissionAware() {
        return this._permissionAware;
    }

    @Override
    public boolean isStagingAware() {
        return this._stagingAware;
    }

    @Override
    public void postProcessContextQuery(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
    }

    @Override
    public void postProcessSearchQuery(BooleanQuery searchQuery, SearchContext searchContext) throws Exception {
        String keywords = searchContext.getKeywords();
        if (Validator.isNull(keywords)) {
            this.addSearchTerm(searchQuery, searchContext, "description", false);
            this.addSearchTerm(searchQuery, searchContext, "title", false);
            this.addSearchTerm(searchQuery, searchContext, "userName", false);
        }
    }

    @Override
    public void registerIndexerPostProcessor(IndexerPostProcessor indexerPostProcessor) {
        List<IndexerPostProcessor> indexerPostProcessorsList = ListUtil.fromArray(this._indexerPostProcessors);
        indexerPostProcessorsList.add(indexerPostProcessor);
        this._indexerPostProcessors = indexerPostProcessorsList.toArray(new IndexerPostProcessor[indexerPostProcessorsList.size()]);
    }

    @Override
    public void reindex(Object obj) throws SearchException {
        try {
            if (SearchEngineUtil.isIndexReadOnly() || !this.isIndexerEnabled()) {
                return;
            }
            this.doReindex(obj);
        }
        catch (SearchException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SearchException(e);
        }
    }

    @Override
    public void reindex(String className, long classPK) throws SearchException {
        try {
            if (SearchEngineUtil.isIndexReadOnly() || !this.isIndexerEnabled()) {
                return;
            }
            this.doReindex(className, classPK);
        }
        catch (NoSuchModelException noSuchModelException) {
            if (_log.isWarnEnabled()) {
                _log.warn("Unable to index " + className + " " + classPK);
            }
        }
        catch (SearchException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SearchException(e);
        }
    }

    @Override
    public void reindex(String[] ids) throws SearchException {
        try {
            if (SearchEngineUtil.isIndexReadOnly() || !this.isIndexerEnabled()) {
                return;
            }
            this.doReindex(ids);
        }
        catch (SearchException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SearchException(e);
        }
    }

    @Override
    public void reindexDDMStructures(List<Long> ddmStructureIds) throws SearchException {
        try {
            if (SearchEngineUtil.isIndexReadOnly() || !this.isIndexerEnabled()) {
                return;
            }
            this.doReindexDDMStructures(ddmStructureIds);
        }
        catch (SearchException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SearchException(e);
        }
    }

    @Override
    public Hits search(SearchContext searchContext) throws SearchException {
        try {
            searchContext.setSearchEngineId(this.getSearchEngineId());
            BooleanQuery fullQuery = this.getFullQuery(searchContext);
            fullQuery.setQueryConfig(searchContext.getQueryConfig());
            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
            int end = searchContext.getEnd();
            int start = searchContext.getStart();
            if (this.isFilterSearch() && permissionChecker != null) {
                searchContext.setEnd(end + INDEX_FILTER_SEARCH_LIMIT);
                searchContext.setStart(0);
            }
            Hits hits = SearchEngineUtil.search(searchContext, fullQuery);
            searchContext.setEnd(end);
            searchContext.setStart(start);
            if (this.isFilterSearch() && permissionChecker != null) {
                hits = this.filterSearch(hits, permissionChecker, searchContext);
            }
            this.processHits(searchContext, hits);
            return hits;
        }
        catch (SearchException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SearchException(e);
        }
    }

    @Override
    public void unregisterIndexerPostProcessor(IndexerPostProcessor indexerPostProcessor) {
        List<IndexerPostProcessor> indexerPostProcessorsList = ListUtil.fromArray(this._indexerPostProcessors);
        indexerPostProcessorsList.remove(indexerPostProcessor);
        this._indexerPostProcessors = indexerPostProcessorsList.toArray(new IndexerPostProcessor[indexerPostProcessorsList.size()]);
    }

    protected void addAssetFields(Document document, String className, long classPK) throws SystemException {
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName(className);
        if (assetRendererFactory == null || !assetRendererFactory.isSelectable()) {
            return;
        }
        AssetEntry assetEntry = AssetEntryLocalServiceUtil.fetchEntry(className, classPK);
        if (assetEntry == null) {
            return;
        }
        if (!document.hasField("createDate")) {
            document.addDate("createDate", assetEntry.getCreateDate());
        }
        if (assetEntry.getExpirationDate() != null) {
            document.addDate("expirationDate", assetEntry.getExpirationDate());
        } else {
            document.addDate("expirationDate", new Date(Long.MAX_VALUE));
        }
        if (!document.hasField("modified")) {
            document.addDate("modified", assetEntry.getModifiedDate());
        }
        document.addNumber("priority", assetEntry.getPriority());
        if (assetEntry.getPublishDate() != null) {
            document.addDate("publishDate", assetEntry.getPublishDate());
        } else {
            document.addDate("publishDate", new Date(0L));
        }
        RatingsStats ratingsStats = RatingsStatsLocalServiceUtil.getStats(className, classPK);
        document.addNumber("ratings", ratingsStats.getAverageScore());
        document.addNumber("viewCount", assetEntry.getViewCount());
        document.addLocalizedKeyword("localized_title", assetEntry.getTitleMap(), true);
    }

    protected void addLocalizedSearchTerm(BooleanQuery searchQuery, SearchContext searchContext, String field, boolean like) throws Exception {
        this.addSearchLocalizedTerm(searchQuery, searchContext, field, like);
    }

    protected void addRelatedClassNames(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        searchContext.setAttribute("relatedClassName", Boolean.TRUE);
        Object[] relatedEntryClassNames = (String[])searchContext.getAttribute("relatedEntryClassNames");
        if (ArrayUtil.isEmpty(relatedEntryClassNames)) {
            return;
        }
        BooleanQuery relatedQueries = BooleanQueryFactoryUtil.create(searchContext);
        Object[] objectArray = relatedEntryClassNames;
        int n = relatedEntryClassNames.length;
        int n2 = 0;
        while (n2 < n) {
            Object relatedEntryClassName = objectArray[n2];
            Indexer indexer = IndexerRegistryUtil.getIndexer((String)relatedEntryClassName);
            if (indexer != null) {
                BooleanQuery relatedQuery = BooleanQueryFactoryUtil.create(searchContext);
                indexer.postProcessContextQuery(relatedQuery, searchContext);
                relatedQuery.addRequiredTerm("classNameId", PortalUtil.getClassNameId((String)relatedEntryClassName));
                relatedQueries.add((Query)relatedQuery, BooleanClauseOccur.SHOULD);
            }
            ++n2;
        }
        contextQuery.add((Query)relatedQueries, BooleanClauseOccur.MUST);
        searchContext.setAttribute("relatedClassName", Boolean.FALSE);
    }

    protected void addSearchArrayQuery(BooleanQuery searchQuery, SearchContext searchContext, String field) throws Exception {
        if (Validator.isNull(field)) {
            return;
        }
        Serializable fieldValues = searchContext.getAttribute(field);
        if (fieldValues == null) {
            return;
        }
        BooleanQuery fieldQuery = null;
        if (fieldValues instanceof int[]) {
            int[] fieldValuesArray = (int[])fieldValues;
            if (fieldValuesArray.length == 0) {
                return;
            }
            fieldQuery = BooleanQueryFactoryUtil.create(searchContext);
            int[] nArray = fieldValuesArray;
            int n = fieldValuesArray.length;
            int n2 = 0;
            while (n2 < n) {
                int fieldValue = nArray[n2];
                fieldQuery.addTerm(field, fieldValue);
                ++n2;
            }
        } else if (fieldValues instanceof Integer[]) {
            Integer[] fieldValuesArray = (Integer[])fieldValues;
            if (fieldValuesArray.length == 0) {
                return;
            }
            fieldQuery = BooleanQueryFactoryUtil.create(searchContext);
            Integer[] integerArray = fieldValuesArray;
            int n = fieldValuesArray.length;
            int n3 = 0;
            while (n3 < n) {
                Integer fieldValue = integerArray[n3];
                fieldQuery.addTerm(field, fieldValue.intValue());
                ++n3;
            }
        } else if (fieldValues instanceof long[]) {
            long[] fieldValuesArray = (long[])fieldValues;
            if (fieldValuesArray.length == 0) {
                return;
            }
            fieldQuery = BooleanQueryFactoryUtil.create(searchContext);
            long[] lArray = fieldValuesArray;
            int n = fieldValuesArray.length;
            int n4 = 0;
            while (n4 < n) {
                long fieldValue = lArray[n4];
                fieldQuery.addTerm(field, fieldValue);
                ++n4;
            }
        } else if (fieldValues instanceof Long[]) {
            Long[] fieldValuesArray = (Long[])fieldValues;
            if (fieldValuesArray.length == 0) {
                return;
            }
            fieldQuery = BooleanQueryFactoryUtil.create(searchContext);
            Long[] longArray = fieldValuesArray;
            int n = fieldValuesArray.length;
            int n5 = 0;
            while (n5 < n) {
                Long fieldValue = longArray[n5];
                fieldQuery.addTerm(field, fieldValue);
                ++n5;
            }
        } else if (fieldValues instanceof short[]) {
            short[] fieldValuesArray = (short[])fieldValues;
            if (fieldValuesArray.length == 0) {
                return;
            }
            fieldQuery = BooleanQueryFactoryUtil.create(searchContext);
            short[] sArray = fieldValuesArray;
            int n = fieldValuesArray.length;
            int n6 = 0;
            while (n6 < n) {
                short fieldValue = sArray[n6];
                fieldQuery.addTerm(field, fieldValue);
                ++n6;
            }
        } else if (fieldValues instanceof Short[]) {
            Short[] fieldValuesArray = (Short[])fieldValues;
            if (fieldValuesArray.length == 0) {
                return;
            }
            fieldQuery = BooleanQueryFactoryUtil.create(searchContext);
            Short[] shortArray = fieldValuesArray;
            int n = fieldValuesArray.length;
            int n7 = 0;
            while (n7 < n) {
                Short fieldValue = shortArray[n7];
                fieldQuery.addTerm(field, fieldValue.shortValue());
                ++n7;
            }
        }
        if (fieldQuery != null) {
            if (searchContext.isAndSearch()) {
                searchQuery.add((Query)fieldQuery, BooleanClauseOccur.MUST);
            } else {
                searchQuery.add((Query)fieldQuery, BooleanClauseOccur.SHOULD);
            }
        }
    }

    protected void addSearchAssetCategoryIds(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        MultiValueFacet multiValueFacet = new MultiValueFacet(searchContext);
        multiValueFacet.setFieldName("assetCategoryIds");
        multiValueFacet.setStatic(true);
        multiValueFacet.setValues(searchContext.getAssetCategoryIds());
        searchContext.addFacet(multiValueFacet);
    }

    protected void addSearchAssetCategoryTitles(Document document, String field, List<AssetCategory> assetCategories) {
        HashMap<Locale, ArrayList<String>> assetCategoryTitles = new HashMap<Locale, ArrayList<String>>();
        Locale defaultLocale = LocaleUtil.getDefault();
        for (AssetCategory assetCategory : assetCategories) {
            Map<Locale, String> titleMap = assetCategory.getTitleMap();
            for (Map.Entry<Locale, String> entry : titleMap.entrySet()) {
                Locale locale = entry.getKey();
                String title = entry.getValue();
                if (Validator.isNull(title)) continue;
                ArrayList<String> titles = (ArrayList<String>)assetCategoryTitles.get(locale);
                if (titles == null) {
                    titles = new ArrayList<String>();
                    assetCategoryTitles.put(locale, titles);
                }
                titles.add(StringUtil.toLowerCase(title));
            }
        }
        for (Map.Entry entry : assetCategoryTitles.entrySet()) {
            Locale locale = (Locale)entry.getKey();
            List titles = (List)entry.getValue();
            String[] titlesArray = titles.toArray(new String[0]);
            if (locale.equals(defaultLocale)) {
                document.addText(field, titlesArray);
            }
            document.addText(field.concat("_").concat(locale.toString()), titlesArray);
        }
    }

    protected void addSearchAssetTagNames(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        MultiValueFacet multiValueFacet = new MultiValueFacet(searchContext);
        multiValueFacet.setFieldName("assetTagNames");
        multiValueFacet.setStatic(true);
        multiValueFacet.setValues(searchContext.getAssetTagNames());
        searchContext.addFacet(multiValueFacet);
    }

    protected void addSearchClassTypeIds(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        long[] classTypeIds = searchContext.getClassTypeIds();
        if (classTypeIds == null || classTypeIds.length <= 0) {
            return;
        }
        BooleanQuery classTypeIdsQuery = BooleanQueryFactoryUtil.create(searchContext);
        long[] lArray = classTypeIds;
        int n = classTypeIds.length;
        int n2 = 0;
        while (n2 < n) {
            long classTypeId = lArray[n2];
            classTypeIdsQuery.addTerm("classTypeId", classTypeId);
            ++n2;
        }
        contextQuery.add((Query)classTypeIdsQuery, BooleanClauseOccur.MUST);
    }

    protected void addSearchDDMStruture(BooleanQuery searchQuery, SearchContext searchContext, DDMStructure ddmStructure) throws Exception {
        Set<String> fieldNames = ddmStructure.getFieldNames();
        for (String fieldName : fieldNames) {
            String indexType = ddmStructure.getFieldProperty(fieldName, "indexType");
            if (Validator.isNull(indexType)) continue;
            String name = DDMIndexerUtil.encodeName(ddmStructure.getStructureId(), fieldName, searchContext.getLocale());
            boolean like = false;
            if (indexType.equals("text")) {
                like = true;
            }
            this.addSearchTerm(searchQuery, searchContext, name, like);
        }
    }

    protected void addSearchEntryClassNames(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        AssetEntriesFacet facet = new AssetEntriesFacet(searchContext);
        facet.setStatic(true);
        searchContext.addFacet(facet);
    }

    protected void addSearchExpando(BooleanQuery searchQuery, SearchContext searchContext, String keywords) throws Exception {
        ExpandoBridge expandoBridge = ExpandoBridgeFactoryUtil.getExpandoBridge(searchContext.getCompanyId(), this.getClassName(searchContext));
        Set<String> attributeNames = SetUtil.fromEnumeration(expandoBridge.getAttributeNames());
        for (String attributeName : attributeNames) {
            UnicodeProperties properties = expandoBridge.getAttributeProperties(attributeName);
            int indexType = GetterUtil.getInteger(properties.getProperty("index-type"));
            if (indexType == 0) continue;
            String fieldName = ExpandoBridgeIndexerUtil.encodeFieldName(attributeName);
            if (!Validator.isNotNull(keywords)) continue;
            if (searchContext.isAndSearch()) {
                searchQuery.addRequiredTerm(fieldName, keywords);
                continue;
            }
            searchQuery.addTerm(fieldName, keywords);
        }
    }

    protected void addSearchFolderId(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        MultiValueFacet multiValueFacet = new MultiValueFacet(searchContext);
        multiValueFacet.setFieldName("treePath");
        multiValueFacet.setStatic(true);
        multiValueFacet.setValues(searchContext.getFolderIds());
        searchContext.addFacet(multiValueFacet);
    }

    protected void addSearchGroupId(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        ScopeFacet facet = new ScopeFacet(searchContext);
        facet.setStatic(true);
        searchContext.addFacet(facet);
    }

    protected void addSearchKeywords(BooleanQuery searchQuery, SearchContext searchContext) throws Exception {
        String keywords = searchContext.getKeywords();
        if (Validator.isNull(keywords)) {
            return;
        }
        searchQuery.addTerms(Field.KEYWORDS, keywords, searchContext.isLike());
        this.addSearchExpando(searchQuery, searchContext, keywords);
    }

    protected void addSearchLayout(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        MultiValueFacet multiValueFacet = new MultiValueFacet(searchContext);
        multiValueFacet.setFieldName("layoutUuid");
        multiValueFacet.setStatic(true);
        searchContext.addFacet(multiValueFacet);
    }

    protected void addSearchLocalizedTerm(BooleanQuery searchQuery, SearchContext searchContext, String field, boolean like) throws Exception {
        this.addSearchTerm(searchQuery, searchContext, field, like);
        this.addSearchTerm(searchQuery, searchContext, DocumentImpl.getLocalizedName(searchContext.getLocale(), field), like);
    }

    protected void addSearchTerm(BooleanQuery searchQuery, SearchContext searchContext, String field, boolean like) throws Exception {
        Class<?> clazz;
        if (Validator.isNull(field)) {
            return;
        }
        String value = null;
        Serializable serializable = searchContext.getAttribute(field);
        value = serializable != null ? ((clazz = serializable.getClass()).isArray() ? StringUtil.merge((Object[])serializable) : GetterUtil.getString(serializable)) : GetterUtil.getString(serializable);
        if (Validator.isNotNull(value) && searchContext.getFacet(field) != null) {
            return;
        }
        if (Validator.isNull(value)) {
            value = searchContext.getKeywords();
        }
        if (Validator.isNull(value)) {
            return;
        }
        if (searchContext.isAndSearch()) {
            searchQuery.addRequiredTerm(field, value, like);
        } else {
            searchQuery.addTerm(field, value, like);
        }
    }

    protected void addSearchUserId(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        MultiValueFacet multiValueFacet = new MultiValueFacet(searchContext);
        multiValueFacet.setFieldName("userId");
        multiValueFacet.setStatic(true);
        long userId = GetterUtil.getLong(searchContext.getAttribute("userId"));
        if (userId > 0L) {
            multiValueFacet.setValues(new long[]{userId});
        }
        searchContext.addFacet(multiValueFacet);
    }

    protected void addStagingGroupKeyword(Document document, long groupId) throws Exception {
        if (!this.isStagingAware()) {
            return;
        }
        boolean stagingGroup = false;
        Group group = GroupLocalServiceUtil.getGroup(groupId);
        if (group.isLayout()) {
            group = GroupLocalServiceUtil.getGroup(group.getParentGroupId());
        }
        if (group.isStagingGroup()) {
            stagingGroup = true;
        }
        document.addKeyword("stagingGroup", stagingGroup);
    }

    protected void addStatus(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        int status = GetterUtil.getInteger(searchContext.getAttribute("status"), 0);
        if (status != -1) {
            contextQuery.addRequiredTerm("status", status);
        } else {
            BooleanQuery statusQuery = BooleanQueryFactoryUtil.create(searchContext);
            statusQuery.addTerm("status", 8L);
            contextQuery.add((Query)statusQuery, BooleanClauseOccur.MUST_NOT);
        }
    }

    protected void addTrashFields(Document document, TrashedModel trashedModel) throws SystemException {
        block13: {
            TrashEntry trashEntry;
            block12: {
                trashEntry = null;
                try {
                    trashEntry = trashedModel.getTrashEntry();
                }
                catch (PortalException portalException) {
                    if (!_log.isDebugEnabled()) break block12;
                    _log.debug("Unable to get trash entry for " + trashedModel);
                }
            }
            if (trashEntry == null) {
                document.addDate("removedDate", new Date());
                ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
                if (serviceContext != null) {
                    try {
                        User user = UserLocalServiceUtil.getUser(serviceContext.getUserId());
                        document.addKeyword("removedByUserName", user.getFullName(), true);
                    }
                    catch (PortalException portalException) {}
                }
            } else {
                document.addDate("removedDate", trashEntry.getCreateDate());
                document.addKeyword("removedByUserName", trashEntry.getUserName(), true);
                if (trashedModel.isInTrash() && !trashEntry.isTrashEntry(trashedModel)) {
                    document.addKeyword("rootEntryClassName", trashEntry.getClassName());
                    document.addKeyword("rootEntryClassPK", trashEntry.getClassPK());
                }
            }
            TrashHandler trashHandler = trashedModel.getTrashHandler();
            try {
                TrashRenderer trashRenderer = null;
                if (trashHandler != null && trashEntry != null) {
                    trashRenderer = trashHandler.getTrashRenderer(trashEntry.getClassPK());
                }
                if (trashRenderer != null) {
                    document.addKeyword("type", trashRenderer.getType(), true);
                }
            }
            catch (PortalException portalException) {
                if (!_log.isDebugEnabled()) break block13;
                _log.debug("Unable to get trash renderer for " + trashEntry.getClassName());
            }
        }
    }

    protected BooleanQuery createFullQuery(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        int n;
        int n2;
        Object[] objectArray;
        BooleanClause[] booleanClauses;
        BooleanQuery searchQuery = BooleanQueryFactoryUtil.create(searchContext);
        this.addSearchKeywords(searchQuery, searchContext);
        this.postProcessSearchQuery(searchQuery, searchContext);
        IndexerPostProcessor[] indexerPostProcessorArray = this._indexerPostProcessors;
        int n3 = this._indexerPostProcessors.length;
        int n4 = 0;
        while (n4 < n3) {
            IndexerPostProcessor indexerPostProcessor = indexerPostProcessorArray[n4];
            indexerPostProcessor.postProcessSearchQuery(searchQuery, searchContext);
            ++n4;
        }
        Map<String, Facet> facets = searchContext.getFacets();
        for (Facet facet : facets.values()) {
            BooleanClause facetClause = facet.getFacetClause();
            if (facetClause == null) continue;
            contextQuery.add(facetClause.getQuery(), facetClause.getBooleanClauseOccur());
        }
        BooleanQuery fullQuery = BooleanQueryFactoryUtil.create(searchContext);
        fullQuery.add((Query)contextQuery, BooleanClauseOccur.MUST);
        if (searchQuery.hasClauses()) {
            fullQuery.add((Query)searchQuery, BooleanClauseOccur.MUST);
        }
        if ((booleanClauses = searchContext.getBooleanClauses()) != null) {
            objectArray = booleanClauses;
            n2 = booleanClauses.length;
            n = 0;
            while (n < n2) {
                Object booleanClause = objectArray[n];
                fullQuery.add(booleanClause.getQuery(), booleanClause.getBooleanClauseOccur());
                ++n;
            }
        }
        this.postProcessFullQuery(fullQuery, searchContext);
        objectArray = this._indexerPostProcessors;
        n2 = this._indexerPostProcessors.length;
        n = 0;
        while (n < n2) {
            Object indexerPostProcessor = objectArray[n];
            indexerPostProcessor.postProcessFullQuery(fullQuery, searchContext);
            ++n;
        }
        return fullQuery;
    }

    protected Summary createLocalizedSummary(Document document, Locale locale) {
        return this.createLocalizedSummary(document, locale, "title", "content");
    }

    protected Summary createLocalizedSummary(Document document, Locale locale, String titleField, String contentField) {
        Locale snippetLocale = this.getSnippetLocale(document, locale);
        String prefix = "snippet_";
        String title = document.get(snippetLocale, String.valueOf(prefix) + titleField, titleField);
        String content = document.get(snippetLocale, String.valueOf(prefix) + contentField, contentField);
        return new Summary(snippetLocale, title, content, null);
    }

    protected Summary createSummary(Document document) {
        return this.createSummary(document, "title", "content");
    }

    protected Summary createSummary(Document document, String titleField, String contentField) {
        String prefix = "snippet_";
        String title = document.get(String.valueOf(prefix) + titleField, titleField);
        String content = document.get(String.valueOf(prefix) + contentField, contentField);
        return new Summary(title, content, null);
    }

    protected void deleteDocument(long companyId, long field1) throws Exception {
        this.deleteDocument(companyId, String.valueOf(field1));
    }

    protected void deleteDocument(long companyId, long field1, String field2) throws Exception {
        this.deleteDocument(companyId, String.valueOf(field1), field2);
    }

    protected void deleteDocument(long companyId, String field1) throws Exception {
        DocumentImpl document = new DocumentImpl();
        document.addUID(this.getPortletId(), field1);
        SearchEngineUtil.deleteDocument(this.getSearchEngineId(), companyId, document.get("uid"));
    }

    protected void deleteDocument(long companyId, String field1, String field2) throws Exception {
        DocumentImpl document = new DocumentImpl();
        document.addUID(this.getPortletId(), field1, field2);
        SearchEngineUtil.deleteDocument(this.getSearchEngineId(), companyId, document.get("uid"));
    }

    protected abstract void doDelete(Object var1) throws Exception;

    protected abstract Document doGetDocument(Object var1) throws Exception;

    protected String doGetSortField(String orderByCol) {
        return orderByCol;
    }

    protected abstract Summary doGetSummary(Document var1, Locale var2, String var3, PortletURL var4) throws Exception;

    protected abstract void doReindex(Object var1) throws Exception;

    protected abstract void doReindex(String var1, long var2) throws Exception;

    protected abstract void doReindex(String[] var1) throws Exception;

    protected void doReindexDDMStructures(List<Long> structureIds) throws Exception {
    }

    protected Hits filterSearch(Hits hits, PermissionChecker permissionChecker, SearchContext searchContext) {
        List<Document> docs = new ArrayList();
        ArrayList<Float> scores = new ArrayList<Float>();
        int start = searchContext.getStart();
        int end = searchContext.getEnd();
        String paginationType = GetterUtil.getString(searchContext.getAttribute("paginationType"), "more");
        boolean hasMore = false;
        Document[] documents = hits.getDocs();
        int excludeDocsSize = 0;
        int i = 0;
        while (i < documents.length) {
            try {
                Document document = documents[i];
                String entryClassName = document.get("entryClassName");
                long entryClassPK = GetterUtil.getLong(document.get("entryClassPK"));
                Indexer indexer = IndexerRegistryUtil.getIndexer(entryClassName);
                if (indexer.isFilterSearch() && indexer.hasPermission(permissionChecker, entryClassName, entryClassPK, "VIEW") || !indexer.isFilterSearch() || !indexer.isPermissionAware()) {
                    docs.add(document);
                    scores.add(Float.valueOf(hits.score(i)));
                } else {
                    ++excludeDocsSize;
                }
            }
            catch (Exception exception) {
                ++excludeDocsSize;
            }
            if (paginationType.equals("more") && end > 0 && end < documents.length && docs.size() >= end) {
                hasMore = true;
                break;
            }
            ++i;
        }
        int length = docs.size();
        if (hasMore) {
            length = documents.length - excludeDocsSize;
        }
        hits.setLength(length);
        if (start != -1 && end != -1) {
            if (end > length) {
                end = length;
            }
            docs = docs.subList(start, end);
        }
        hits.setDocs(docs.toArray(new Document[docs.size()]));
        hits.setScores(scores.toArray(new Float[docs.size()]));
        hits.setSearchTime((float)(System.currentTimeMillis() - hits.getStart()) / 1000.0f);
        return hits;
    }

    protected Document getBaseModelDocument(String portletId, BaseModel<?> baseModel) throws SystemException {
        return this.getBaseModelDocument(portletId, baseModel, baseModel);
    }

    protected Document getBaseModelDocument(String portletId, BaseModel<?> baseModel, BaseModel<?> workflowedBaseModel) throws SystemException {
        TrashedModel trashedModel;
        Document document = this.newDocument();
        String className = baseModel.getModelClassName();
        long classPK = 0L;
        long resourcePrimKey = 0L;
        if (baseModel instanceof ResourcedModel) {
            ResourcedModel resourcedModel = (ResourcedModel)((Object)baseModel);
            classPK = resourcedModel.getResourcePrimKey();
            resourcePrimKey = resourcedModel.getResourcePrimKey();
        } else {
            classPK = (Long)baseModel.getPrimaryKeyObj();
        }
        document.addUID(portletId, classPK);
        List<AssetCategory> assetCategories = AssetCategoryLocalServiceUtil.getCategories(className, classPK);
        long[] assetCategoryIds = StringUtil.split(ListUtil.toString(assetCategories, AssetCategory.CATEGORY_ID_ACCESSOR), 0L);
        document.addKeyword("assetCategoryIds", assetCategoryIds);
        this.addSearchAssetCategoryTitles(document, "assetCategoryTitles", assetCategories);
        String[] assetTagNames = AssetTagLocalServiceUtil.getTagNames(className, classPK);
        document.addText("assetTagNames", assetTagNames);
        List<AssetTag> assetTags = AssetTagLocalServiceUtil.getTags(className, classPK);
        long[] assetTagsIds = StringUtil.split(ListUtil.toString(assetTags, AssetTag.TAG_ID_ACCESSOR), 0L);
        document.addKeyword("assetTagIds", assetTagsIds);
        document.addKeyword("entryClassName", className);
        document.addKeyword("entryClassPK", classPK);
        document.addKeyword("portletId", portletId);
        if (resourcePrimKey > 0L) {
            document.addKeyword("rootEntryClassPK", resourcePrimKey);
        }
        if (baseModel instanceof AttachedModel) {
            AttachedModel attachedModel = (AttachedModel)((Object)baseModel);
            document.addKeyword("classNameId", attachedModel.getClassNameId());
            document.addKeyword("classPK", attachedModel.getClassPK());
        }
        if (baseModel instanceof AuditedModel) {
            AuditedModel auditedModel = (AuditedModel)((Object)baseModel);
            document.addKeyword("companyId", auditedModel.getCompanyId());
            document.addDate("createDate", auditedModel.getCreateDate());
            document.addDate("modified", auditedModel.getModifiedDate());
            document.addKeyword("userId", auditedModel.getUserId());
            String userName = PortalUtil.getUserName(auditedModel.getUserId(), auditedModel.getUserName());
            document.addKeyword("userName", userName, true);
        }
        GroupedModel groupedModel = null;
        if (baseModel instanceof GroupedModel) {
            groupedModel = (GroupedModel)((Object)baseModel);
            document.addKeyword("groupId", this.getSiteGroupId(groupedModel.getGroupId()));
            document.addKeyword("scopeGroupId", groupedModel.getGroupId());
        }
        if (workflowedBaseModel instanceof WorkflowedModel) {
            WorkflowedModel workflowedModel = (WorkflowedModel)((Object)workflowedBaseModel);
            document.addKeyword("status", workflowedModel.getStatus());
        }
        if (groupedModel != null && baseModel instanceof TrashedModel && (trashedModel = (TrashedModel)((Object)baseModel)).isInTrash()) {
            this.addTrashFields(document, trashedModel);
        }
        this.addAssetFields(document, className, classPK);
        ExpandoBridgeIndexerUtil.addAttributes(document, baseModel.getExpandoBridge());
        return document;
    }

    protected String getClassName(SearchContext searchContext) {
        String[] classNames = this.getClassNames();
        return classNames[0];
    }

    protected Set<String> getLocalizedCountryNames(Country country) {
        Locale[] locales;
        HashSet<String> countryNames = new HashSet<String>();
        Locale[] localeArray = locales = LanguageUtil.getAvailableLocales();
        int n = locales.length;
        int n2 = 0;
        while (n2 < n) {
            Locale locale = localeArray[n2];
            String countryName = country.getName(locale);
            countryName = StringUtil.toLowerCase(countryName);
            countryNames.add(countryName);
            ++n2;
        }
        return countryNames;
    }

    protected long getParentGroupId(long groupId) {
        return this.getSiteGroupId(groupId);
    }

    protected abstract String getPortletId(SearchContext var1);

    protected long getSiteGroupId(long groupId) {
        long siteGroupId = groupId;
        try {
            Group group = GroupLocalServiceUtil.getGroup(groupId);
            if (group.isLayout()) {
                siteGroupId = group.getParentGroupId();
            }
        }
        catch (Exception exception) {}
        return siteGroupId;
    }

    protected Locale getSnippetLocale(Document document, Locale locale) {
        String prefix = "snippet_";
        String localizedContentName = String.valueOf(prefix) + DocumentImpl.getLocalizedName(locale, "content");
        String localizedDescriptionName = String.valueOf(prefix) + DocumentImpl.getLocalizedName(locale, "description");
        String localizedTitleName = String.valueOf(prefix) + DocumentImpl.getLocalizedName(locale, "title");
        if (document.getField(localizedContentName) != null || document.getField(localizedDescriptionName) != null || document.getField(localizedTitleName) != null) {
            return locale;
        }
        return null;
    }

    protected Document newDocument() {
        return (Document)this._document.clone();
    }

    protected void populateAddresses(Document document, List<Address> addresses, long regionId, long countryId) throws PortalException, SystemException {
        ArrayList<String> regions;
        ArrayList<String> countries;
        ArrayList<String> cities;
        block8: {
            block7: {
                cities = new ArrayList<String>();
                countries = new ArrayList<String>();
                if (countryId > 0L) {
                    try {
                        Country country = CountryServiceUtil.getCountry(countryId);
                        countries.addAll(this.getLocalizedCountryNames(country));
                    }
                    catch (NoSuchCountryException nsce) {
                        if (!_log.isWarnEnabled()) break block7;
                        _log.warn(nsce.getMessage());
                    }
                }
            }
            regions = new ArrayList<String>();
            if (regionId > 0L) {
                try {
                    Region region = RegionServiceUtil.getRegion(regionId);
                    regions.add(StringUtil.toLowerCase(region.getName()));
                }
                catch (NoSuchRegionException nsre) {
                    if (!_log.isWarnEnabled()) break block8;
                    _log.warn(nsre.getMessage());
                }
            }
        }
        ArrayList<String> streets = new ArrayList<String>();
        ArrayList<String> zips = new ArrayList<String>();
        for (Address address : addresses) {
            cities.add(StringUtil.toLowerCase(address.getCity()));
            countries.addAll(this.getLocalizedCountryNames(address.getCountry()));
            regions.add(StringUtil.toLowerCase(address.getRegion().getName()));
            streets.add(StringUtil.toLowerCase(address.getStreet1()));
            streets.add(StringUtil.toLowerCase(address.getStreet2()));
            streets.add(StringUtil.toLowerCase(address.getStreet3()));
            zips.add(StringUtil.toLowerCase(address.getZip()));
        }
        document.addText("city", cities.toArray(new String[cities.size()]));
        document.addText("country", countries.toArray(new String[countries.size()]));
        document.addText("region", regions.toArray(new String[regions.size()]));
        document.addText("street", streets.toArray(new String[streets.size()]));
        document.addText("zip", zips.toArray(new String[zips.size()]));
    }

    protected void postProcessFullQuery(BooleanQuery fullQuery, SearchContext searchContext) throws Exception {
    }

    protected void processHits(SearchContext searchContext, Hits hits) throws SearchException {
        HitsProcessor hitsProcessor = HitsProcessorRegistryUtil.getDefaultHitsProcessor();
        if (hitsProcessor != null) {
            hitsProcessor.process(searchContext, hits);
        }
    }

    protected void setFilterSearch(boolean filterSearch) {
        this._filterSearch = filterSearch;
    }

    protected void setIndexerEnabled(boolean indexerEnabled) {
        this._indexerEnabled = indexerEnabled;
    }

    protected void setPermissionAware(boolean permissionAware) {
        this._permissionAware = permissionAware;
    }

    protected void setSortableTextFields(String[] sortableTextFields) {
        this._document.setSortableTextFields(sortableTextFields);
    }

    protected void setStagingAware(boolean stagingAware) {
        this._stagingAware = stagingAware;
    }
}

