/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.portal.kernel.cluster.Priority;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BooleanClauseFactory;
import com.liferay.portal.kernel.search.BooleanQueryFactory;
import com.liferay.portal.kernel.search.IndexSearcher;
import com.liferay.portal.kernel.search.IndexWriter;
import com.liferay.portal.kernel.search.SearchEngine;
import com.liferay.portal.kernel.search.TermQueryFactory;
import com.liferay.portal.kernel.search.TermRangeQueryFactory;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;

@DoPrivileged
public class BaseSearchEngine
implements SearchEngine {
    private static Log _log = LogFactoryUtil.getLog(BaseSearchEngine.class);
    private BooleanClauseFactory _booleanClauseFactory;
    private BooleanQueryFactory _booleanQueryFactory;
    private boolean _clusteredWrite;
    private Priority _clusteredWritePriority;
    private IndexSearcher _indexSearcher;
    private IndexWriter _indexWriter;
    private boolean _luceneBased;
    private TermQueryFactory _termQueryFactory;
    private TermRangeQueryFactory _termRangeQueryFactory;
    private String _vendor;

    @Override
    public BooleanClauseFactory getBooleanClauseFactory() {
        if (this._booleanClauseFactory == null) {
            ClassLoader classLoader = PortalClassLoaderUtil.getClassLoader();
            String className = "com.liferay.portal.search.generic.BooleanClauseFactoryImpl";
            try {
                this._booleanClauseFactory = (BooleanClauseFactory)InstanceFactory.newInstance(classLoader, className);
            }
            catch (Exception e) {
                _log.fatal("Unable to locate appropriate BooleanClauseFactory", e);
            }
        }
        return this._booleanClauseFactory;
    }

    @Override
    public BooleanQueryFactory getBooleanQueryFactory() {
        if (this._booleanQueryFactory != null) {
            return this._booleanQueryFactory;
        }
        ClassLoader classLoader = PortalClassLoaderUtil.getClassLoader();
        String className = "com.liferay.portal.search.lucene.BooleanQueryFactoryImpl";
        if (!this.isLuceneBased()) {
            className = "com.liferay.portal.search.generic.BooleanQueryFactoryImpl";
        }
        try {
            this._booleanQueryFactory = (BooleanQueryFactory)InstanceFactory.newInstance(classLoader, className);
        }
        catch (Exception e) {
            _log.fatal("Unable to locate appropriate BooleanQueryFactory", e);
        }
        return this._booleanQueryFactory;
    }

    @Override
    public Priority getClusteredWritePriority() {
        return this._clusteredWritePriority;
    }

    @Override
    public IndexSearcher getIndexSearcher() {
        return this._indexSearcher;
    }

    @Override
    public IndexWriter getIndexWriter() {
        return this._indexWriter;
    }

    @Override
    public TermQueryFactory getTermQueryFactory() {
        if (this._termQueryFactory != null) {
            return this._termQueryFactory;
        }
        ClassLoader classLoader = PortalClassLoaderUtil.getClassLoader();
        String className = "com.liferay.portal.search.lucene.TermQueryFactoryImpl";
        if (!this.isLuceneBased()) {
            className = "com.liferay.portal.search.generic.TermQueryFactoryImpl";
        }
        try {
            this._termQueryFactory = (TermQueryFactory)InstanceFactory.newInstance(classLoader, className);
        }
        catch (Exception e) {
            _log.fatal("Unable to locate appropriate BooleanQueryFactory", e);
        }
        return this._termQueryFactory;
    }

    @Override
    public TermRangeQueryFactory getTermRangeQueryFactory() {
        if (this._termRangeQueryFactory != null) {
            return this._termRangeQueryFactory;
        }
        ClassLoader classLoader = PortalClassLoaderUtil.getClassLoader();
        String className = "com.liferay.portal.search.lucene.TermRangeQueryFactoryImpl";
        if (!this.isLuceneBased()) {
            className = "com.liferay.portal.search.generic.TermRangeQueryFactoryImpl";
        }
        try {
            this._termRangeQueryFactory = (TermRangeQueryFactory)InstanceFactory.newInstance(classLoader, className);
        }
        catch (Exception e) {
            _log.fatal("Unable to locate appropriate BooleanQueryFactory", e);
        }
        return this._termRangeQueryFactory;
    }

    @Override
    public String getVendor() {
        return this._vendor;
    }

    @Override
    public boolean isClusteredWrite() {
        return this._clusteredWrite;
    }

    @Override
    public boolean isLuceneBased() {
        return this._luceneBased;
    }

    public void setBooleanClauseFactory(BooleanClauseFactory booleanClauseFactory) {
        this._booleanClauseFactory = booleanClauseFactory;
    }

    public void setBooleanQueryFactory(BooleanQueryFactory booleanQueryFactory) {
        this._booleanQueryFactory = booleanQueryFactory;
    }

    public void setClusteredWrite(boolean clusteredWrite) {
        this._clusteredWrite = clusteredWrite;
    }

    public void setClusteredWritePriority(Priority clusteredWritePriority) {
        this._clusteredWritePriority = clusteredWritePriority;
    }

    public void setIndexSearcher(IndexSearcher indexSearcher) {
        this._indexSearcher = indexSearcher;
    }

    public void setIndexWriter(IndexWriter indexWriter) {
        this._indexWriter = indexWriter;
    }

    public void setLuceneBased(boolean luceneBased) {
        this._luceneBased = luceneBased;
    }

    public void setTermQueryFactory(TermQueryFactory termQueryFactory) {
        this._termQueryFactory = termQueryFactory;
    }

    public void setTermRangeQueryFactory(TermRangeQueryFactory termRangeQueryFactory) {
        this._termRangeQueryFactory = termRangeQueryFactory;
    }

    public void setVendor(String vendor) {
        this._vendor = vendor;
    }
}

